﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_Mutex.h>

namespace nn { namespace nim { namespace srv {
    class ManualClearSystemEvent : public os::SystemEvent
    {
    public:
        ManualClearSystemEvent() NN_NOEXCEPT : os::SystemEvent(os::EventClearMode_ManualClear, true) {}
    };

    class NonRecursiveMutex : public os::Mutex
    {
    public:
        NonRecursiveMutex() NN_NOEXCEPT : os::Mutex(false) {}
    };

    class RecursiveMutex : public os::Mutex
    {
    public:
        RecursiveMutex() NN_NOEXCEPT : os::Mutex(true) {}
    };
}}}
