﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_NintendoAccountTypes.h>
#include <nn/ec/system/ec_VirtualAccountTypes.h>
#include <nn/es/es_Types.h>
#include <nn/kvdb/kvdb_BoundedString.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_ContentId.h>
#include <nn/nim/nim_EciAccessorDefinition.h>

namespace nn { namespace nim { namespace srv {

    typedef kvdb::BoundedString<256> Url;

    void MakeSystemUpdateMetaQueryUrl(Url* outValue, Bit64 deviceId) NN_NOEXCEPT;

    void MakeContentMetaQueryUrl(Url* outValue, Bit64 id, uint32_t version, ncm::ContentMetaType type, Bit64 deviceId, bool isSystem) NN_NOEXCEPT;

    void MakeContentMetaUrl(Url* outValue, const ncm::ContentId& contentId, ncm::ContentMetaType type, bool isSystem) NN_NOEXCEPT;

    void MakeContentUrl(Url* outValue, const ncm::ContentId& contentId, bool isSystem) NN_NOEXCEPT;

    void MakeApplicationControlContentUrl(Url* outValue, const ncm::ApplicationId& appId, uint32_t version) NN_NOEXCEPT;

    void MakeLatestApplicationControlContentUrl(Url* outValue, const ncm::ApplicationId& appId) NN_NOEXCEPT;

    void MakeLatestVersionUrl(Url* outValue, Bit64 id) NN_NOEXCEPT;

    void MakeLatestVersionArrayUrl(Url* outValue, Bit64 id) NN_NOEXCEPT;

    void MakeGameCardRegistrationStatusUrl(Url* outValue) NN_NOEXCEPT;

    void MakeRegisterGameCardUrl(Url* outValue) NN_NOEXCEPT;

    void MakeNotificationTokenRegisterUrl(Url* outValue, Bit64 deviceId) NN_NOEXCEPT;

    void MakeDownloadTaskListUrl(Url* outValue, Bit64 deviceId) NN_NOEXCEPT;

    void MakeVersionListUrl(Url* outValue) NN_NOEXCEPT;

    void MakeUnlinkDeviceUrl(Url* outValue) NN_NOEXCEPT;

    void MakeUnlinkDeviceAllUrl(Url* outValue, Bit64 deviceId) NN_NOEXCEPT;

    void MakeLinkDeviceUrl(Url* outValue) NN_NOEXCEPT;

    void MakeCreateVirtualAccountUrl(Url* outValue) NN_NOEXCEPT;

    void MakeDeviceLinkStatusUrl(Url* outValue) NN_NOEXCEPT;

    void MakeVirtualAccountUrl(Url* outValue) NN_NOEXCEPT;

    void MakeDownloadCommonTicketUrl(Url* outValue, const es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;

    void MakeSystemUpdateMetaForContentDeliveryUrl(Url* outValue, Bit64 deviceId) NN_NOEXCEPT;
}}}
