﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ncm/ncm_InstallTaskBase.h>
#include <nn/ncm/ncm_ContentInfoData.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_ContentMeta.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/nim/nim_LocalCommunicationSendSystemUpdateTaskInfo.h>
#include <nn/nim/srv/nim_LocalCommunicationConfig.h>
#include <nn/nim/srv/nim_LocalCommunicationSendContentTaskBase.h>
#include <nn/os/os_Mutex.h>
#include <nn/nim/srv/nim_LocalCommunicationDeliveryProtocol.h>

namespace nn { namespace nim { namespace srv {

    class LocalCommunicationSendSystemUpdateTask : public LocalCommunicationSendContentTaskBase
    {
    public:
        //--------------------------------------------------------------------------
        //  AsyncTaskResultImpl で実行するために必要なメソッド
        //--------------------------------------------------------------------------
        Result InitializeBeforeRun() NN_NOEXCEPT
        {
            // 必要なら追加する
            NN_RESULT_SUCCESS;
        }
        void FinalizeAfterRun() NN_NOEXCEPT
        {
            // 必要なら追加する
        }

        //--------------------------------------------------------------------------
        //  一般公開メソッド
        //--------------------------------------------------------------------------

        Result Initialize(uint32_t ipv4, uint16_t port, const ncm::ContentMetaKey& key) NN_NOEXCEPT;

    protected:
        virtual Result GetPackagedContentInfo(ncm::PackagedContentInfo *outValue, const ncm::ContentMetaKey& key) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result GetStorage(ncm::StorageId* outValue, const ncm::ContentId& contentId) NN_NOEXCEPT NN_OVERRIDE;

    private:
        ncm::ContentMetaKey m_SystemUpdateKey;
    };
}}}
