﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/err/err_ErrorContext.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ncm/ncm_InstallTaskBase.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_ContentMeta.h>
#include "nim_LocalCommunicationDeliveryProtocol.h"

namespace nn { namespace nim { namespace srv {

    class LocalCommunicationReceiveContentTaskBase : public ncm::InstallTaskBase
    {
    public:
        virtual void Cancel() NN_NOEXCEPT NN_OVERRIDE;
        virtual void ResetCancel() NN_NOEXCEPT NN_OVERRIDE;
        void SetBuffer(void* buffer, size_t bufferSize) NN_NOEXCEPT
        {
            m_Buffer = static_cast<char*>(buffer);
            m_BufferSize = bufferSize;
        }
        Result InitializeBeforeRun() NN_NOEXCEPT
        {
            // TODO: 何かあれば追加する
            NN_RESULT_SUCCESS;
        }
        void FinalizeAfterRun() NN_NOEXCEPT
        {
            // TODO: 何かあれば追加する
        }
        void GetErrorContext(err::ErrorContext* outValue) const NN_NOEXCEPT
        {
            *outValue = m_ErrorContext;
        }

    protected:
        Result Initialize(uint32_t ipv4, uint16_t port, ncm::StorageId storage, ncm::InstallTaskDataBase* data, Bit32 config) NN_NOEXCEPT;
        Result InitializeForCleanup(ncm::StorageId storage, ncm::InstallTaskDataBase* data, Bit32 config) NN_NOEXCEPT;
        virtual Result GetInstallContentMetaInfo(ncm::InstallContentMetaInfo* outValue, const ncm::ContentMetaKey& key) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result OnPrepareComplete() NN_NOEXCEPT NN_OVERRIDE;

        LocalCommunicationDeliveryProtocolClient m_Connection;
        err::ErrorContext m_ErrorContext{};

    private:
        // TODO: 本来 ncm::InstallTaskBase にあるべき
        virtual int CountInstallContentMetaKey() NN_NOEXCEPT = 0;
        virtual Result GetInstallContentMetaKey(ncm::ContentMetaKey* outValue, int index) NN_NOEXCEPT = 0;

        virtual Result PrepareInstallContentMetaData() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result OnWritePlaceHolder(ncm::InstallContentInfo* data) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result OnExecuteComplete() NN_NOEXCEPT NN_OVERRIDE;

        ncm::InstallTaskDataBase* m_Data{};
        char* m_Buffer{};
        size_t m_BufferSize{};
    };
}}}
