﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Mutex.h>
#include <nn/ec/system/ec_DeviceAuthenticationTypes.h>
#include <nn/nim/srv/nim_SimpleDataCache.h>

namespace nn { namespace nim { namespace srv {

    struct DeviceAuthenticationTokenInfo
    {
        TimeSpan expireTime;
        ec::system::DeviceAuthenticationToken token;
    };

    class DeviceAuthenticationTokenInfoCache : public SimpleDataCache<DeviceAuthenticationTokenInfo>
    {
    public:
        DeviceAuthenticationTokenInfoCache() NN_NOEXCEPT : m_Mutex(false) {};

        void Save(const DeviceAuthenticationTokenInfo& token) NN_NOEXCEPT;
        void Clear() NN_NOEXCEPT;
        bool Get(DeviceAuthenticationTokenInfo* outValue) NN_NOEXCEPT;

    private:
        os::Mutex m_Mutex;
    };
}}}
