﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Thread.h>
#include <nn/os/os_Event.h>
#include <nn/os/os_Tick.h>
#include <nn/nim/nim_BackgroundDownloadStressTaskInfo.h>
#include <nn/ncm/ncm_ContentStorage.h>
#include <nn/ncm/ncm_ContentMetaId.h>

namespace nn { namespace nim { namespace srv {

    class BackgroundApplyDeltaStressTask
    {
    public:
        BackgroundApplyDeltaStressTask() NN_NOEXCEPT;

        ~BackgroundApplyDeltaStressTask() NN_NOEXCEPT;

        Result Initialize(ncm::ApplicationId id, ncm::StorageId storageId) NN_NOEXCEPT;

        void Run() NN_NOEXCEPT;

        // Download とプログレスは同じなので、とりあえず同じの受け取るとしておく
        void GetInfo(BackgroundDownloadStressTaskInfo* outValue) const NN_NOEXCEPT;

    private:
        Result Execute() NN_NOEXCEPT;

        void CleanupContentStorage() NN_NOEXCEPT;

        void Measure(size_t downloadSize) NN_NOEXCEPT;

        void ResetMeasure() NN_NOEXCEPT {m_BeginMeasurement = os::GetSystemTick();}

        ncm::ApplicationId m_ApplicationId;
        ncm::StorageId m_StorageId;
        os::ThreadType m_Thread;
        os::Event m_Event;
        os::Tick m_BeginMeasurement;
        Bit8*  m_Buffer;
        size_t m_BufferSize;
        int64_t m_WriteOffset;
        double m_Throughput; // KB/s
        Result m_LastResult;
        bool m_IsInitialized;
        BackgroundDownloadStressTaskState m_State;
    };

}}}

