﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_ContentStorage.h>
#include <nn/nim/nim_SystemUpdateTaskId.h>
#include <nn/nim/nim_SystemUpdateTaskInfo.h>
#include <nn/nim/nim_NetworkInstallTaskId.h>
#include <nn/nim/nim_NetworkInstallTaskInfo.h>
#include <nn/nim/nim_ApplyDeltaTaskId.h>
#include <nn/nim/nim_Async.h>
#include <nn/nim/nim_LocalCommunicationReceiveApplicationTaskId.h>
#include <nn/nim/nim_LocalCommunicationReceiveApplicationTaskInfo.h>
#include <nn/nim/nim_LocalCommunicationReceiveSystemUpdateTaskId.h>
#include <nn/nim/nim_LocalCommunicationReceiveSystemUpdateTaskInfo.h>
#include <nn/nim/nim_LocalCommunicationSendSystemUpdateTaskId.h>
#include <nn/nim/nim_LocalCommunicationSendSystemUpdateTaskInfo.h>
#include <nn/nim/nim_BackgroundDownloadStressTaskInfo.h>
#include <nn/nim/nim_ETag.h>
#include <nn/nim/nim_GameCardRegistrationStatus.h>
#include <nn/nim/detail/nim_INetworkInstallManager.sfdl.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace nim {

    void InitializeForNetworkInstallManager();

    void FinalizeForNetworkInstallManager();

    Result CreateSystemUpdateTask(SystemUpdateTaskId* outValue, const ncm::ContentMetaKey& key, bool requiresExFatDriver) NN_NOEXCEPT;

    Result DestroySystemUpdateTask(const SystemUpdateTaskId& id) NN_NOEXCEPT;

    int ListSystemUpdateTask(SystemUpdateTaskId outList[], int count) NN_NOEXCEPT;

    Result RequestSystemUpdateTaskRun(AsyncResult* outValue, const SystemUpdateTaskId& id) NN_NOEXCEPT;

    Result GetSystemUpdateTaskInfo(SystemUpdateTaskInfo* outValue, const SystemUpdateTaskId& id) NN_NOEXCEPT;

    Result CommitSystemUpdateTask(const SystemUpdateTaskId& id) NN_NOEXCEPT;

    Result CreateNetworkInstallTask(NetworkInstallTaskId* outValue, ncm::ApplicationId appId, const ncm::ContentMetaKey keyList[], int count, ncm::StorageId storage) NN_NOEXCEPT;

    Result CreateNetworkInstallTask(NetworkInstallTaskId* outValue, ncm::ApplicationId appId, const ncm::ContentMetaKey keyList[], int count, ncm::StorageId storage, Bit32 config) NN_NOEXCEPT;

    Result DestroyNetworkInstallTask(const NetworkInstallTaskId& id) NN_NOEXCEPT;

    int ListNetworkInstallTask(NetworkInstallTaskId outList[], int count) NN_NOEXCEPT;

    Result RequestNetworkInstallTaskRun(AsyncResult* outValue, const NetworkInstallTaskId& id) NN_NOEXCEPT;

    Result GetNetworkInstallTaskInfo(NetworkInstallTaskInfo* outValue, const NetworkInstallTaskId& id) NN_NOEXCEPT;

    Result GetNetworkInstallTaskErrorContext(err::ErrorContext* outValue, const NetworkInstallTaskId& id) NN_NOEXCEPT;

    Result ListNetworkInstallTaskContentMeta(int* outValue, ncm::StorageContentMetaKey* outList, int count, int offset, const NetworkInstallTaskId& id) NN_NOEXCEPT;

    Result ListNetworkInstallTaskCommittedContentMeta(int* outValue, ncm::StorageContentMetaKey* outList, int count, int offset, const NetworkInstallTaskId& id) NN_NOEXCEPT;

    Result ListNetworkInstallTaskNotCommittedContentMeta(int* outValue, ncm::StorageContentMetaKey* outList, int count, int offset, const NetworkInstallTaskId& id) NN_NOEXCEPT;

    Result ListNetworkInstallTaskContentMetaFromInstallMeta(int* outValue, ncm::ContentMetaKey* outList, int count, int offset, const NetworkInstallTaskId& id) NN_NOEXCEPT;

    Result CommitNetworkInstallTask(const NetworkInstallTaskId& id) NN_NOEXCEPT;

    Result CommitNetworkInstallTaskPartially(const ncm::StorageContentMetaKey list[], int count, const NetworkInstallTaskId& id) NN_NOEXCEPT;

    int ListApplicationNetworkInstallTask(NetworkInstallTaskId outList[], int count, ncm::ApplicationId appId) NN_NOEXCEPT;

    Result AddNetworkInstallTaskContentMeta(const ncm::ContentMetaKey list[], int count, const NetworkInstallTaskId& id) NN_NOEXCEPT;

    Result SetNetworkInstallTaskAttribute(const NetworkInstallTaskId& id, Bit64 attribute) NN_NOEXCEPT;

    Result CalculateNetworkInstallTaskRequiredSize(int64_t* outValue, const NetworkInstallTaskId& id) NN_NOEXCEPT;

    Result CalculateNetworkInstallTaskContentsSize(int64_t* outValue, const NetworkInstallTaskId& id, const ncm::ContentMetaKey& key, ncm::StorageId storageId) NN_NOEXCEPT;

    Result ListNetworkInstallTaskOccupiedSize(int* outCount, ncm::InstallTaskOccupiedSize* outList, int numList, int offset, const NetworkInstallTaskId& id) NN_NOEXCEPT;

    typedef detail::AsyncValue<ncm::ContentMetaKey> AsyncContentMetaKey;
    Result RequestSystemUpdateMeta(AsyncContentMetaKey* outValue) NN_NOEXCEPT;

    struct ApplicationControlInfo
    {
        ncm::Path path;
        uint32_t version;
    };
    typedef detail::AsyncValue<ApplicationControlInfo> AsyncApplicationControlInfo;
    Result RequestApplicationControl(AsyncApplicationControlInfo* outValue, ncm::ApplicationId id, uint32_t version) NN_NOEXCEPT;

    typedef detail::AsyncValue<ApplicationControlInfo> AsyncApplicationControlInfo;
    Result RequestLatestApplicationControl(AsyncApplicationControlInfo* outValue, ncm::ApplicationId id) NN_NOEXCEPT;

    typedef detail::AsyncValueListLegacy<ncm::ContentMetaKey> AsyncLatestKeyList;
    Result RequestLatestVersion(AsyncLatestKeyList* outValue, ncm::ApplicationId id) NN_NOEXCEPT;

    Result GetDownloadedSystemDataPath(ncm::Path* outValue, ncm::SystemDataId dataId, const nim::SystemUpdateTaskId& taskId) NN_NOEXCEPT;

    Result IsExFatDriverIncluded(bool* outValue, const SystemUpdateTaskId& taskId) NN_NOEXCEPT;

    Result GetBackgroundDownloadStressTaskInfo(BackgroundDownloadStressTaskInfo* outValue) NN_NOEXCEPT;

    Result GetBackgroundApplyDeltaStressTaskInfo(BackgroundDownloadStressTaskInfo* outValue) NN_NOEXCEPT;

    const int MaxRegisterableApplicationCount = 16; // サーバ側の上限は無いとのこと
    typedef detail::AsyncValue<GameCardRegistrationStatus> AsyncGameCardRegistrationStatus;
    Result RequestGameCardRegistrationStatus(AsyncGameCardRegistrationStatus* outValue, const ncm::ApplicationId appIdList[], int appIdCount, const char* token, const void* cert, size_t bufferSize) NN_NOEXCEPT;

    Result RequestRegisterGameCard(AsyncResult* outValue, const ncm::ApplicationId appIdList[], int appIdCount, const char* token, const void* cert, size_t bufferSize, GameCardRegistrationStatus status) NN_NOEXCEPT;

    Result RequestRegisterNotificationToken(AsyncResult* outValue, const npns::NotificationToken& token) NN_NOEXCEPT;

    Result RequestDownloadTaskList(AsyncData* outValue, const ETag& eTag) NN_NOEXCEPT;

    Result RequestVersionList(AsyncData* outValue, const ETag& eTag) NN_NOEXCEPT;

    Result CreateApplyDeltaTask(ApplyDeltaTaskId* outValue, ncm::ApplicationId applicationId, const ncm::ContentMetaKey& sourceKey, const ncm::ContentMetaKey keyList[], int count, ncm::StorageId storageId) NN_NOEXCEPT;

    Result CreateApplyDeltaTaskFromDownloadTask(ApplyDeltaTaskId* outValue, const NetworkInstallTaskId& id) NN_NOEXCEPT;

    Result DestroyApplyDeltaTask(const ApplyDeltaTaskId& id) NN_NOEXCEPT;

    int ListApplyDeltaTask(ApplyDeltaTaskId outList[], int count) NN_NOEXCEPT;
    int ListApplicationApplyDeltaTask(ApplyDeltaTaskId outList[], int count, ncm::ApplicationId applicationId) NN_NOEXCEPT;

    Result RequestApplyDeltaTaskRun(AsyncResult* outValue, const ApplyDeltaTaskId& id) NN_NOEXCEPT;

    Result ClearNotEnoughSpaceStateOfApplyDeltaTask(const ApplyDeltaTaskId& id) NN_NOEXCEPT;

    Result GetApplyDeltaTaskInfo(ApplyDeltaTaskInfo* outValue, const ApplyDeltaTaskId& id) NN_NOEXCEPT;

    Result ListApplyDeltaTaskContentMeta(int* outValue, ncm::StorageContentMetaKey* outList, int count, int offset, const ApplyDeltaTaskId& id) NN_NOEXCEPT;

    Result CommitApplyDeltaTask(const ApplyDeltaTaskId& id) NN_NOEXCEPT;

    Result CalculateApplyDeltaTaskRequiredSize(int64_t* outValue, const ApplyDeltaTaskId& id) NN_NOEXCEPT;

    Result CalculateApplyDeltaTaskOccupiedSize(int64_t* outValue, const ApplyDeltaTaskId& id, ncm::StorageId storageId) NN_NOEXCEPT;

    Result GetApplyDeltaTaskRequiredStorage(ncm::StorageId* outValue, const ApplyDeltaTaskId& id) NN_NOEXCEPT;

    Result FindMaxRequiredApplicationVersionOfTask(uint32_t* outValue, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;

    Result FindMaxRequiredSystemVersionOfTask(uint32_t* outValue, const nim::NetworkInstallTaskId& id) NN_NOEXCEPT;

    Result PrepareShutdown() NN_NOEXCEPT;

    Result PrepareShutdownForSystemUpdate() NN_NOEXCEPT;

    Result CreateLocalCommunicationReceiveApplicationTask(LocalCommunicationReceiveApplicationTaskId* outValue, uint32_t ipv4, uint16_t port, ncm::ApplicationId appId, const ncm::ContentMetaKey keyList[], int count, ncm::StorageId storage) NN_NOEXCEPT;

    Result RequestLocalCommunicationReceiveApplicationTaskRun(AsyncResult* outValue, const LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;

    Result DestroyLocalCommunicationReceiveApplicationTask(const LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;

    int ListLocalCommunicationReceiveApplicationTask(LocalCommunicationReceiveApplicationTaskId outList[], int count) NN_NOEXCEPT;

    int ListApplicationLocalCommunicationReceiveApplicationTask(LocalCommunicationReceiveApplicationTaskId outList[], int listCount, ncm::ApplicationId appId) NN_NOEXCEPT;

    Result GetLocalCommunicationReceiveApplicationTaskInfo(LocalCommunicationReceiveApplicationTaskInfo* outValue, const LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;

    Result ListLocalCommunicationReceiveApplicationTaskContentMeta(int* outValue, ncm::StorageContentMetaKey* outList, int count, int offset, const LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;

    Result CommitLocalCommunicationReceiveApplicationTask(const LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;

    Result GetLocalCommunicationReceiveApplicationTaskErrorContext(err::ErrorContext* outValue, const LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;

    Result CalculateLocalCommunicationReceiveApplicationTaskRequiredSize(int64_t* outValue, const LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;

    Result CreateLocalCommunicationSendApplicationTask(LocalCommunicationSendApplicationTaskId* outValue, uint32_t ipv4, uint16_t port, const ncm::StorageContentMetaKey keyList[], int count, ncm::ApplicationId id) NN_NOEXCEPT;

    Result RequestLocalCommunicationSendApplicationTaskRun(AsyncResult* outValue, const LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;

    Result GetLocalCommunicationSendApplicationTaskInfo(LocalCommunicationSendApplicationTaskInfo* outValue, const LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;

    Result DestroyLocalCommunicationSendApplicationTask(const LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;

    Result GetLocalCommunicationSendApplicationTaskErrorContext(err::ErrorContext* outValue, const LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;

    int ListApplicationLocalCommunicationSendApplicationTask(LocalCommunicationSendApplicationTaskId outList[], int countList, ncm::ApplicationId appId) NN_NOEXCEPT;

    Result CreateLocalCommunicationReceiveSystemUpdateTask(LocalCommunicationReceiveSystemUpdateTaskId* outValue, uint32_t ipv4, uint16_t port, const ncm::ContentMetaKey& key, Bit32 config) NN_NOEXCEPT;

    Result DestroyLocalCommunicationReceiveSystemUpdateTask(const LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;

    int ListLocalCommunicationReceiveSystemUpdateTask(LocalCommunicationReceiveSystemUpdateTaskId outList[], int listCount) NN_NOEXCEPT;

    Result RequestLocalCommunicationReceiveSystemUpdateTaskRun(AsyncResult* outValue, const LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;

    Result GetLocalCommunicationReceiveSystemUpdateTaskInfo(nim::LocalCommunicationReceiveSystemUpdateTaskInfo* outValue, const LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;

    Result CommitLocalCommunicationReceiveSystemUpdateTask(const LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;

    Result GetLocalCommunicationReceiveSystemUpdateTaskErrorContext(err::ErrorContext* outValue, const nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;

    Result GetReceivedSystemDataPath(ncm::Path* outValue, ncm::SystemDataId dataId, const nim::LocalCommunicationReceiveSystemUpdateTaskId& taskId) NN_NOEXCEPT;

    Result CreateLocalCommunicationSendSystemUpdateTask(nim::LocalCommunicationSendSystemUpdateTaskId* outValue, uint32_t ipv4, uint16_t port, const ncm::ContentMetaKey& key) NN_NOEXCEPT;

    Result RequestLocalCommunicationSendSystemUpdateTaskRun(AsyncResult* outValue, const nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;

    Result GetLocalCommunicationSendSystemUpdateTaskInfo(nim::LocalCommunicationSendSystemUpdateTaskInfo* outValue, const nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;

    Result DestroyLocalCommunicationSendSystemUpdateTask(const nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;

    Result GetLocalCommunicationSendSystemUpdateTaskErrorContext(err::ErrorContext* outValue, const nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;

    int ListLocalCommunicationSendSystemUpdateTask(nim::LocalCommunicationSendSystemUpdateTaskId outList[], int listCount) NN_NOEXCEPT;

    void ReloadErrorSimulation() NN_NOEXCEPT;
}}
