﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <type_traits>
#include <nn/nn_StaticAssert.h>
#include <nn/nn_Common.h>

namespace nn { namespace nim {

    struct ETag {
        Bit8 data[40];

        static ETag MakeEmpty() NN_NOEXCEPT { return{}; }
        bool IsEmpty() const NN_NOEXCEPT;
    };
    NN_STATIC_ASSERT(std::is_pod<ETag>().value);

    inline bool operator ==(const ETag& lhs, const ETag& rhs) NN_NOEXCEPT
    {
        return std::memcmp(lhs.data, rhs.data, sizeof(lhs.data)) == 0;
    }

    inline bool operator !=(const ETag& lhs, const ETag& rhs) NN_NOEXCEPT
    {
        return !(lhs == rhs);
    }

    inline bool ETag::IsEmpty() const NN_NOEXCEPT
    {
        return (*this) == ETag::MakeEmpty();
    }
}}
