﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_StaticAssert.h>

namespace nn { namespace nim {

    enum class BackgroundDownloadStressTaskState : uint8_t
    {
        NotRunning = 0,
        Waiting = 1,
        Downloading = 2,
        Error = 3,
    };

    struct BackgroundDownloadStressTaskInfo
    {
        bool isEnabled;
        BackgroundDownloadStressTaskState state;
        ncm::StorageId                    storageId;
        Bit8 reserved[1];
        uint32_t lastResultValue;
        double throughput;

        Result GetLastResult() const NN_NOEXCEPT
        {
            return result::detail::ConstructResult(lastResultValue);
        }
    };
    NN_STATIC_ASSERT(sizeof(BackgroundDownloadStressTaskInfo) == 16);

}}
