﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/account/account_NintendoAccountTypes.h>
#include <nn/account/account_Types.h>
#include <nn/err/err_ErrorContext.h>
#include <nn/es/es_ELicenseTypes.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_ContentStorage.h>
#include <nn/ncm/ncm_InstallTaskOccupiedSize.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>
#include <nn/nim/nim_ApplyDeltaTaskId.h>
#include <nn/nim/nim_BackgroundDownloadStressTaskInfo.h>
#include <nn/nim/nim_DynamicRightsApi.h>
#include <nn/nim/nim_ETag.h>
#include <nn/nim/nim_GameCardRegistrationStatus.h>
#include <nn/nim/nim_LocalCommunicationReceiveApplicationTaskId.h>
#include <nn/nim/nim_LocalCommunicationReceiveApplicationTaskInfo.h>
#include <nn/nim/nim_LocalCommunicationReceiveSystemUpdateTaskId.h>
#include <nn/nim/nim_LocalCommunicationReceiveSystemUpdateTaskInfo.h>
#include <nn/nim/nim_LocalCommunicationSendApplicationTaskId.h>
#include <nn/nim/nim_LocalCommunicationSendApplicationTaskInfo.h>
#include <nn/nim/nim_LocalCommunicationSendSystemUpdateTaskId.h>
#include <nn/nim/nim_LocalCommunicationSendSystemUpdateTaskInfo.h>
#include <nn/nim/nim_NetworkInstallTaskId.h>
#include <nn/nim/nim_NetworkInstallTaskInfo.h>
#include <nn/nim/nim_SystemUpdateTaskId.h>
#include <nn/nim/nim_SystemUpdateTaskInfo.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/npns/npns_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace nim { namespace detail { // NOLINT(whitespace/braces)

class INetworkInstallManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(INetworkInstallManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(INetworkInstallManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSystemUpdateTask, (::nn::sf::Out<::nn::nim::SystemUpdateTaskId> outValue, const ::nn::ncm::ContentMetaKey& key, ::nn::Bit32 config))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroySystemUpdateTask, (const ::nn::nim::SystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListSystemUpdateTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::SystemUpdateTaskId>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestSystemUpdateTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::SystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemUpdateTaskInfo, (::nn::sf::Out<::nn::nim::SystemUpdateTaskInfo> outValue, const ::nn::nim::SystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CommitSystemUpdateTask, (const ::nn::nim::SystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateNetworkInstallTask, (::nn::sf::Out<::nn::nim::NetworkInstallTaskId> outValue, ::nn::ncm::ApplicationId appId, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storage, ::nn::Bit32 config))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyNetworkInstallTask, (const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::NetworkInstallTaskId>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestNetworkInstallTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkInstallTaskInfo, (::nn::sf::Out<::nn::nim::NetworkInstallTaskInfo> outValue, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CommitNetworkInstallTask, (const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestLatestSystemUpdateMeta, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationNetworkInstallTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::NetworkInstallTaskId>& outList, ::nn::ncm::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestLatestVersion, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetNetworkInstallTaskAttribute, (const ::nn::nim::NetworkInstallTaskIdAttribute& idAttribute))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddNetworkInstallTaskContentMeta, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& list, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadedSystemDataPath, (::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::SystemDataId dataId, const ::nn::nim::SystemUpdateTaskId& taskId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CalculateNetworkInstallTaskRequiredSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsExFatDriverIncluded, (::nn::sf::Out<bool> outValue, const ::nn::nim::SystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundDownloadStressTaskInfo, (::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestDeviceAuthenticationToken, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestGameCardRegistrationStatus, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& appIdList, const ::nn::sf::InBuffer& token, const ::nn::sf::InBuffer& cert))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestRegisterGameCard, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& appIdList, const ::nn::sf::InBuffer& token, const ::nn::sf::InBuffer& cert, ::nn::nim::GameCardRegistrationStatus status))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestRegisterNotificationToken, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::npns::NotificationToken& notificationToken))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadTaskList, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outAsync, const ::nn::nim::ETag& eTag))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplicationControl, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId applicationId, ::std::uint32_t version))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestLatestApplicationControl, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestVersionList, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outAsync, const ::nn::nim::ETag& eTag))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateApplyDeltaTask, (::nn::sf::Out<::nn::nim::ApplyDeltaTaskId> outValue, ::nn::ncm::ApplicationId appId, const ::nn::ncm::ContentMetaKey& sourceKey, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyApplyDeltaTask, (const ::nn::nim::ApplyDeltaTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationApplyDeltaTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::ApplyDeltaTaskId>& outList, ::nn::ncm::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplyDeltaTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::ApplyDeltaTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplyDeltaTaskInfo, (::nn::sf::Out<::nn::nim::ApplyDeltaTaskInfo> outValue, const ::nn::nim::ApplyDeltaTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplyDeltaTaskContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::ApplyDeltaTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CommitApplyDeltaTask, (const ::nn::nim::ApplyDeltaTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplyDeltaTaskRequiredSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::ApplyDeltaTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(PrepareShutdown)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplyDeltaTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::ApplyDeltaTaskId>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ClearNotEnoughSpaceStateOfApplyDeltaTask, (const ::nn::nim::ApplyDeltaTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateApplyDeltaTaskFromDownloadTask, (::nn::sf::Out<::nn::nim::ApplyDeltaTaskId> outValue, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundApplyDeltaStressTaskInfo, (::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplyDeltaTaskRequiredStorage, (::nn::sf::Out<::nn::ncm::StorageId> outValue, const ::nn::nim::ApplyDeltaTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CalculateNetworkInstallTaskContentsSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::NetworkInstallTaskId& id, const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(PrepareShutdownForSystemUpdate)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FindMaxRequiredApplicationVersionOfTask, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CommitNetworkInstallTaskPartially, (const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>& list, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskCommittedContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskNotCommittedContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FindMaxRequiredSystemVersionOfTask, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkInstallTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateLocalCommunicationReceiveApplicationTask, (::nn::sf::Out<::nn::nim::LocalCommunicationReceiveApplicationTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, ::nn::ncm::ApplicationId appId, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storage, ::nn::Bit32 config))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationReceiveApplicationTask, (const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListLocalCommunicationReceiveApplicationTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestLocalCommunicationReceiveApplicationTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveApplicationTaskInfo, (::nn::sf::Out<::nn::nim::LocalCommunicationReceiveApplicationTaskInfo> outValue, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CommitLocalCommunicationReceiveApplicationTask, (const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListLocalCommunicationReceiveApplicationTaskContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateLocalCommunicationSendApplicationTask, (::nn::sf::Out<::nn::nim::LocalCommunicationSendApplicationTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>& keyList, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestLocalCommunicationSendApplicationTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationSendApplicationTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveApplicationTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendApplicationTaskInfo, (::nn::sf::Out<::nn::nim::LocalCommunicationSendApplicationTaskInfo> outValue, const ::nn::nim::LocalCommunicationSendApplicationTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationSendApplicationTask, (const ::nn::nim::LocalCommunicationSendApplicationTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendApplicationTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationSendApplicationTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CalculateLocalCommunicationReceiveApplicationTaskRequiredSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationLocalCommunicationReceiveApplicationTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList, ::nn::ncm::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationLocalCommunicationSendApplicationTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationSendApplicationTaskId>& outList, ::nn::ncm::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateLocalCommunicationReceiveSystemUpdateTask, (::nn::sf::Out<::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ncm::ContentMetaKey& key, ::nn::Bit32 config))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationReceiveSystemUpdateTask, (const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListLocalCommunicationReceiveSystemUpdateTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestLocalCommunicationReceiveSystemUpdateTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveSystemUpdateTaskInfo, (::nn::sf::Out<::nn::nim::LocalCommunicationReceiveSystemUpdateTaskInfo> outValue, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CommitLocalCommunicationReceiveSystemUpdateTask, (const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveSystemUpdateTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateLocalCommunicationSendSystemUpdateTask, (::nn::sf::Out<::nn::nim::LocalCommunicationSendSystemUpdateTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ncm::ContentMetaKey& key))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestLocalCommunicationSendSystemUpdateTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendSystemUpdateTaskInfo, (::nn::sf::Out<::nn::nim::LocalCommunicationSendSystemUpdateTaskInfo> outValue, const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationSendSystemUpdateTask, (const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendSystemUpdateTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListLocalCommunicationSendSystemUpdateTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationSendSystemUpdateTaskId>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivedSystemDataPath, (::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::SystemDataId dataId, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& taskId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplyDeltaTaskOccupiedSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::ApplyDeltaTaskId& id, ::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(ReloadErrorSimulation)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskContentMetaFromInstallMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskOccupiedSize, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::InstallTaskOccupiedSize>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestQueryAvailableELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestAssignELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIds, ::nn::nim::ELicenseType licenseType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestExtendELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, ::nn::account::NintendoAccountId naId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadETickets, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestQueryRevokeReason, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outValue, ::nn::account::NintendoAccountId naId, const ::nn::es::ELicenseId& eLicenseId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestReportActiveELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, ::nn::account::NintendoAccountId naId, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestReportActiveELicensesPassively, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, ::nn::account::NintendoAccountId naId, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestRegisterDynamicRightsNotificationToken, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::npns::NotificationToken& notificationToken))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestAssignAllDeviceLinkedELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(INetworkInstallManager)

        ::nn::Result CreateSystemUpdateTask(::nn::sf::Out<::nn::nim::SystemUpdateTaskId> outValue, const ::nn::ncm::ContentMetaKey& key, ::nn::Bit32 config) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSystemUpdateTask, (outValue, key, config));
        }

        ::nn::Result DestroySystemUpdateTask(const ::nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroySystemUpdateTask, (id));
        }

        ::nn::Result ListSystemUpdateTask(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::SystemUpdateTaskId>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListSystemUpdateTask, (outCount, outList));
        }

        ::nn::Result RequestSystemUpdateTaskRun(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestSystemUpdateTaskRun, (outHandle, outAsync, id));
        }

        ::nn::Result GetSystemUpdateTaskInfo(::nn::sf::Out<::nn::nim::SystemUpdateTaskInfo> outValue, const ::nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemUpdateTaskInfo, (outValue, id));
        }

        ::nn::Result CommitSystemUpdateTask(const ::nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CommitSystemUpdateTask, (id));
        }

        ::nn::Result CreateNetworkInstallTask(::nn::sf::Out<::nn::nim::NetworkInstallTaskId> outValue, ::nn::ncm::ApplicationId appId, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storage, ::nn::Bit32 config) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateNetworkInstallTask, (outValue, appId, keyList, storage, config));
        }

        ::nn::Result DestroyNetworkInstallTask(const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyNetworkInstallTask, (id));
        }

        ::nn::Result ListNetworkInstallTask(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::NetworkInstallTaskId>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListNetworkInstallTask, (outCount, outList));
        }

        ::nn::Result RequestNetworkInstallTaskRun(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestNetworkInstallTaskRun, (outHandle, outAsync, id));
        }

        ::nn::Result GetNetworkInstallTaskInfo(::nn::sf::Out<::nn::nim::NetworkInstallTaskInfo> outValue, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNetworkInstallTaskInfo, (outValue, id));
        }

        ::nn::Result CommitNetworkInstallTask(const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CommitNetworkInstallTask, (id));
        }

        ::nn::Result RequestLatestSystemUpdateMeta(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestLatestSystemUpdateMeta, (outHandle, outAsync));
        }

        ::nn::Result ListApplicationNetworkInstallTask(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::NetworkInstallTaskId>& outList, ::nn::ncm::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationNetworkInstallTask, (outCount, outList, appId));
        }

        ::nn::Result ListNetworkInstallTaskContentMeta(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskContentMeta, (outCount, outList, offset, id));
        }

        ::nn::Result RequestLatestVersion(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestLatestVersion, (outHandle, outAsync, appId));
        }

        ::nn::Result SetNetworkInstallTaskAttribute(const ::nn::nim::NetworkInstallTaskIdAttribute& idAttribute) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetNetworkInstallTaskAttribute, (idAttribute));
        }

        ::nn::Result AddNetworkInstallTaskContentMeta(const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& list, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddNetworkInstallTaskContentMeta, (list, id));
        }

        ::nn::Result GetDownloadedSystemDataPath(::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::SystemDataId dataId, const ::nn::nim::SystemUpdateTaskId& taskId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDownloadedSystemDataPath, (outValue, dataId, taskId));
        }

        ::nn::Result CalculateNetworkInstallTaskRequiredSize(::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CalculateNetworkInstallTaskRequiredSize, (outValue, id));
        }

        ::nn::Result IsExFatDriverIncluded(::nn::sf::Out<bool> outValue, const ::nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsExFatDriverIncluded, (outValue, id));
        }

        ::nn::Result GetBackgroundDownloadStressTaskInfo(::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBackgroundDownloadStressTaskInfo, (outValue));
        }

        ::nn::Result RequestDeviceAuthenticationToken(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestDeviceAuthenticationToken, (outHandle, outAsync));
        }

        ::nn::Result RequestGameCardRegistrationStatus(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& appIdList, const ::nn::sf::InBuffer& token, const ::nn::sf::InBuffer& cert) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestGameCardRegistrationStatus, (outHandle, outAsync, appIdList, token, cert));
        }

        ::nn::Result RequestRegisterGameCard(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& appIdList, const ::nn::sf::InBuffer& token, const ::nn::sf::InBuffer& cert, ::nn::nim::GameCardRegistrationStatus status) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestRegisterGameCard, (outHandle, outAsync, appIdList, token, cert, status));
        }

        ::nn::Result RequestRegisterNotificationToken(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::npns::NotificationToken& notificationToken) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestRegisterNotificationToken, (outHandle, outAsync, notificationToken));
        }

        ::nn::Result RequestDownloadTaskList(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outAsync, const ::nn::nim::ETag& eTag) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestDownloadTaskList, (outHandle, outAsync, eTag));
        }

        ::nn::Result RequestApplicationControl(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId applicationId, ::std::uint32_t version) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestApplicationControl, (outHandle, outAsync, applicationId, version));
        }

        ::nn::Result RequestLatestApplicationControl(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestLatestApplicationControl, (outHandle, outAsync, applicationId));
        }

        ::nn::Result RequestVersionList(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outAsync, const ::nn::nim::ETag& eTag) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestVersionList, (outHandle, outAsync, eTag));
        }

        ::nn::Result CreateApplyDeltaTask(::nn::sf::Out<::nn::nim::ApplyDeltaTaskId> outValue, ::nn::ncm::ApplicationId appId, const ::nn::ncm::ContentMetaKey& sourceKey, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateApplyDeltaTask, (outValue, appId, sourceKey, keyList, storageId));
        }

        ::nn::Result DestroyApplyDeltaTask(const ::nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyApplyDeltaTask, (id));
        }

        ::nn::Result ListApplicationApplyDeltaTask(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::ApplyDeltaTaskId>& outList, ::nn::ncm::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationApplyDeltaTask, (outCount, outList, appId));
        }

        ::nn::Result RequestApplyDeltaTaskRun(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestApplyDeltaTaskRun, (outHandle, outAsync, id));
        }

        ::nn::Result GetApplyDeltaTaskInfo(::nn::sf::Out<::nn::nim::ApplyDeltaTaskInfo> outValue, const ::nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplyDeltaTaskInfo, (outValue, id));
        }

        ::nn::Result ListApplyDeltaTaskContentMeta(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplyDeltaTaskContentMeta, (outCount, outList, offset, id));
        }

        ::nn::Result CommitApplyDeltaTask(const ::nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CommitApplyDeltaTask, (id));
        }

        ::nn::Result CalculateApplyDeltaTaskRequiredSize(::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CalculateApplyDeltaTaskRequiredSize, (outValue, id));
        }

        ::nn::Result PrepareShutdown() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(PrepareShutdown);
        }

        ::nn::Result ListApplyDeltaTask(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::ApplyDeltaTaskId>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplyDeltaTask, (outCount, outList));
        }

        ::nn::Result ClearNotEnoughSpaceStateOfApplyDeltaTask(const ::nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ClearNotEnoughSpaceStateOfApplyDeltaTask, (id));
        }

        ::nn::Result CreateApplyDeltaTaskFromDownloadTask(::nn::sf::Out<::nn::nim::ApplyDeltaTaskId> outValue, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateApplyDeltaTaskFromDownloadTask, (outValue, id));
        }

        ::nn::Result GetBackgroundApplyDeltaStressTaskInfo(::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBackgroundApplyDeltaStressTaskInfo, (outValue));
        }

        ::nn::Result GetApplyDeltaTaskRequiredStorage(::nn::sf::Out<::nn::ncm::StorageId> outValue, const ::nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplyDeltaTaskRequiredStorage, (outValue, id));
        }

        ::nn::Result CalculateNetworkInstallTaskContentsSize(::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::NetworkInstallTaskId& id, const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CalculateNetworkInstallTaskContentsSize, (outValue, id, key, storageId));
        }

        ::nn::Result PrepareShutdownForSystemUpdate() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(PrepareShutdownForSystemUpdate);
        }

        ::nn::Result FindMaxRequiredApplicationVersionOfTask(::nn::sf::Out<::std::uint32_t> outValue, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FindMaxRequiredApplicationVersionOfTask, (outValue, id));
        }

        ::nn::Result CommitNetworkInstallTaskPartially(const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>& list, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CommitNetworkInstallTaskPartially, (list, id));
        }

        ::nn::Result ListNetworkInstallTaskCommittedContentMeta(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskCommittedContentMeta, (outCount, outList, offset, id));
        }

        ::nn::Result ListNetworkInstallTaskNotCommittedContentMeta(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskNotCommittedContentMeta, (outCount, outList, offset, id));
        }

        ::nn::Result FindMaxRequiredSystemVersionOfTask(::nn::sf::Out<::std::uint32_t> outValue, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FindMaxRequiredSystemVersionOfTask, (outValue, id));
        }

        ::nn::Result GetNetworkInstallTaskErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNetworkInstallTaskErrorContext, (outValue, id));
        }

        ::nn::Result CreateLocalCommunicationReceiveApplicationTask(::nn::sf::Out<::nn::nim::LocalCommunicationReceiveApplicationTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, ::nn::ncm::ApplicationId appId, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storage, ::nn::Bit32 config) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateLocalCommunicationReceiveApplicationTask, (outValue, ipv4, port, appId, keyList, storage, config));
        }

        ::nn::Result DestroyLocalCommunicationReceiveApplicationTask(const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationReceiveApplicationTask, (id));
        }

        ::nn::Result ListLocalCommunicationReceiveApplicationTask(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListLocalCommunicationReceiveApplicationTask, (outCount, outList));
        }

        ::nn::Result RequestLocalCommunicationReceiveApplicationTaskRun(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestLocalCommunicationReceiveApplicationTaskRun, (outHandle, outAsync, id));
        }

        ::nn::Result GetLocalCommunicationReceiveApplicationTaskInfo(::nn::sf::Out<::nn::nim::LocalCommunicationReceiveApplicationTaskInfo> outValue, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveApplicationTaskInfo, (outValue, id));
        }

        ::nn::Result CommitLocalCommunicationReceiveApplicationTask(const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CommitLocalCommunicationReceiveApplicationTask, (id));
        }

        ::nn::Result ListLocalCommunicationReceiveApplicationTaskContentMeta(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListLocalCommunicationReceiveApplicationTaskContentMeta, (outCount, outList, offset, id));
        }

        ::nn::Result CreateLocalCommunicationSendApplicationTask(::nn::sf::Out<::nn::nim::LocalCommunicationSendApplicationTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>& keyList, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateLocalCommunicationSendApplicationTask, (outValue, ipv4, port, keyList, id));
        }

        ::nn::Result RequestLocalCommunicationSendApplicationTaskRun(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestLocalCommunicationSendApplicationTaskRun, (outHandle, outAsync, id));
        }

        ::nn::Result GetLocalCommunicationReceiveApplicationTaskErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveApplicationTaskErrorContext, (outValue, id));
        }

        ::nn::Result GetLocalCommunicationSendApplicationTaskInfo(::nn::sf::Out<::nn::nim::LocalCommunicationSendApplicationTaskInfo> outValue, const ::nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendApplicationTaskInfo, (outValue, id));
        }

        ::nn::Result DestroyLocalCommunicationSendApplicationTask(const ::nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationSendApplicationTask, (id));
        }

        ::nn::Result GetLocalCommunicationSendApplicationTaskErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendApplicationTaskErrorContext, (outValue, id));
        }

        ::nn::Result CalculateLocalCommunicationReceiveApplicationTaskRequiredSize(::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CalculateLocalCommunicationReceiveApplicationTaskRequiredSize, (outValue, id));
        }

        ::nn::Result ListApplicationLocalCommunicationReceiveApplicationTask(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList, ::nn::ncm::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationLocalCommunicationReceiveApplicationTask, (outCount, outList, appId));
        }

        ::nn::Result ListApplicationLocalCommunicationSendApplicationTask(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationSendApplicationTaskId>& outList, ::nn::ncm::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationLocalCommunicationSendApplicationTask, (outCount, outList, appId));
        }

        ::nn::Result CreateLocalCommunicationReceiveSystemUpdateTask(::nn::sf::Out<::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ncm::ContentMetaKey& key, ::nn::Bit32 config) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateLocalCommunicationReceiveSystemUpdateTask, (outValue, ipv4, port, key, config));
        }

        ::nn::Result DestroyLocalCommunicationReceiveSystemUpdateTask(const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationReceiveSystemUpdateTask, (id));
        }

        ::nn::Result ListLocalCommunicationReceiveSystemUpdateTask(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListLocalCommunicationReceiveSystemUpdateTask, (outCount, outList));
        }

        ::nn::Result RequestLocalCommunicationReceiveSystemUpdateTaskRun(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestLocalCommunicationReceiveSystemUpdateTaskRun, (outHandle, outAsync, id));
        }

        ::nn::Result GetLocalCommunicationReceiveSystemUpdateTaskInfo(::nn::sf::Out<::nn::nim::LocalCommunicationReceiveSystemUpdateTaskInfo> outValue, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveSystemUpdateTaskInfo, (outValue, id));
        }

        ::nn::Result CommitLocalCommunicationReceiveSystemUpdateTask(const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CommitLocalCommunicationReceiveSystemUpdateTask, (id));
        }

        ::nn::Result GetLocalCommunicationReceiveSystemUpdateTaskErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveSystemUpdateTaskErrorContext, (outValue, id));
        }

        ::nn::Result CreateLocalCommunicationSendSystemUpdateTask(::nn::sf::Out<::nn::nim::LocalCommunicationSendSystemUpdateTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateLocalCommunicationSendSystemUpdateTask, (outValue, ipv4, port, key));
        }

        ::nn::Result RequestLocalCommunicationSendSystemUpdateTaskRun(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestLocalCommunicationSendSystemUpdateTaskRun, (outHandle, outAsync, id));
        }

        ::nn::Result GetLocalCommunicationSendSystemUpdateTaskInfo(::nn::sf::Out<::nn::nim::LocalCommunicationSendSystemUpdateTaskInfo> outValue, const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendSystemUpdateTaskInfo, (outValue, id));
        }

        ::nn::Result DestroyLocalCommunicationSendSystemUpdateTask(const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationSendSystemUpdateTask, (id));
        }

        ::nn::Result GetLocalCommunicationSendSystemUpdateTaskErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendSystemUpdateTaskErrorContext, (outValue, id));
        }

        ::nn::Result ListLocalCommunicationSendSystemUpdateTask(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationSendSystemUpdateTaskId>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListLocalCommunicationSendSystemUpdateTask, (outCount, outList));
        }

        ::nn::Result GetReceivedSystemDataPath(::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::SystemDataId dataId, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& taskId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReceivedSystemDataPath, (outValue, dataId, taskId));
        }

        ::nn::Result CalculateApplyDeltaTaskOccupiedSize(::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::ApplyDeltaTaskId& id, ::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CalculateApplyDeltaTaskOccupiedSize, (outValue, id, storageId));
        }

        void ReloadErrorSimulation() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(ReloadErrorSimulation);
        }

        ::nn::Result ListNetworkInstallTaskContentMetaFromInstallMeta(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskContentMetaFromInstallMeta, (outCount, outList, offset, id));
        }

        ::nn::Result ListNetworkInstallTaskOccupiedSize(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::InstallTaskOccupiedSize>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskOccupiedSize, (outCount, outList, offset, id));
        }

        ::nn::Result RequestQueryAvailableELicenses(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestQueryAvailableELicenses, (outHandle, outValue, uid, rightsIds));
        }

        ::nn::Result RequestAssignELicenses(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIds, ::nn::nim::ELicenseType licenseType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestAssignELicenses, (outHandle, outValue, uid, rightsIds, licenseType));
        }

        ::nn::Result RequestExtendELicenses(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestExtendELicenses, (outHandle, outValue, uid, elicenseIds));
        }

        ::nn::Result RequestSyncELicenses(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, ::nn::account::NintendoAccountId naId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestSyncELicenses, (outHandle, outValue, naId));
        }

        ::nn::Result RequestDownloadETickets(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestDownloadETickets, (outHandle, outValue, uid, elicenseIds));
        }

        ::nn::Result RequestQueryRevokeReason(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outValue, ::nn::account::NintendoAccountId naId, const ::nn::es::ELicenseId& eLicenseId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestQueryRevokeReason, (outHandle, outValue, naId, eLicenseId));
        }

        ::nn::Result RequestReportActiveELicenses(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, ::nn::account::NintendoAccountId naId, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestReportActiveELicenses, (outHandle, outValue, naId, elicenseIds));
        }

        ::nn::Result RequestReportActiveELicensesPassively(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, ::nn::account::NintendoAccountId naId, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestReportActiveELicensesPassively, (outHandle, outValue, naId, elicenseIds));
        }

        ::nn::Result RequestRegisterDynamicRightsNotificationToken(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::npns::NotificationToken& notificationToken) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestRegisterDynamicRightsNotificationToken, (outHandle, outAsync, notificationToken));
        }

        ::nn::Result RequestAssignAllDeviceLinkedELicenses(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestAssignAllDeviceLinkedELicenses, (outHandle, outValue));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class INetworkInstallManager
    {
    public:
        nn::Result CreateSystemUpdateTask(nn::sf::Out<nn::nim::SystemUpdateTaskId> outValue, const nn::ncm::ContentMetaKey& key, nn::Bit32 config) NN_NOEXCEPT;
        nn::Result DestroySystemUpdateTask(const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result ListSystemUpdateTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::SystemUpdateTaskId>& outList) NN_NOEXCEPT;
        nn::Result RequestSystemUpdateTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result GetSystemUpdateTaskInfo(nn::sf::Out<nn::nim::SystemUpdateTaskInfo> outValue, const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result CommitSystemUpdateTask(const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result CreateNetworkInstallTask(nn::sf::Out<nn::nim::NetworkInstallTaskId> outValue, nn::ncm::ApplicationId appId, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storage, nn::Bit32 config) NN_NOEXCEPT;
        nn::Result DestroyNetworkInstallTask(const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result ListNetworkInstallTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::NetworkInstallTaskId>& outList) NN_NOEXCEPT;
        nn::Result RequestNetworkInstallTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result GetNetworkInstallTaskInfo(nn::sf::Out<nn::nim::NetworkInstallTaskInfo> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result CommitNetworkInstallTask(const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result RequestLatestSystemUpdateMeta(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
        nn::Result ListApplicationNetworkInstallTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::NetworkInstallTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
        nn::Result ListNetworkInstallTaskContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result RequestLatestVersion(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
        nn::Result SetNetworkInstallTaskAttribute(const nn::nim::NetworkInstallTaskIdAttribute& idAttribute) NN_NOEXCEPT;
        nn::Result AddNetworkInstallTaskContentMeta(const nn::sf::InArray<nn::ncm::ContentMetaKey>& list, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result GetDownloadedSystemDataPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::SystemDataId dataId, const nn::nim::SystemUpdateTaskId& taskId) NN_NOEXCEPT;
        nn::Result CalculateNetworkInstallTaskRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result IsExFatDriverIncluded(nn::sf::Out<bool> outValue, const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result GetBackgroundDownloadStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT;
        nn::Result RequestDeviceAuthenticationToken(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
        nn::Result RequestGameCardRegistrationStatus(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, const nn::sf::InArray<nn::ncm::ApplicationId>& appIdList, const nn::sf::InBuffer& token, const nn::sf::InBuffer& cert) NN_NOEXCEPT;
        nn::Result RequestRegisterGameCard(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::sf::InArray<nn::ncm::ApplicationId>& appIdList, const nn::sf::InBuffer& token, const nn::sf::InBuffer& cert, nn::nim::GameCardRegistrationStatus status) NN_NOEXCEPT;
        nn::Result RequestRegisterNotificationToken(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::npns::NotificationToken& notificationToken) NN_NOEXCEPT;
        nn::Result RequestDownloadTaskList(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outAsync, const nn::nim::ETag& eTag) NN_NOEXCEPT;
        nn::Result RequestApplicationControl(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId applicationId, std::uint32_t version) NN_NOEXCEPT;
        nn::Result RequestLatestApplicationControl(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result RequestVersionList(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outAsync, const nn::nim::ETag& eTag) NN_NOEXCEPT;
        nn::Result CreateApplyDeltaTask(nn::sf::Out<nn::nim::ApplyDeltaTaskId> outValue, nn::ncm::ApplicationId appId, const nn::ncm::ContentMetaKey& sourceKey, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result DestroyApplyDeltaTask(const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        nn::Result ListApplicationApplyDeltaTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::ApplyDeltaTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
        nn::Result RequestApplyDeltaTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        nn::Result GetApplyDeltaTaskInfo(nn::sf::Out<nn::nim::ApplyDeltaTaskInfo> outValue, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        nn::Result ListApplyDeltaTaskContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        nn::Result CommitApplyDeltaTask(const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        nn::Result CalculateApplyDeltaTaskRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        nn::Result PrepareShutdown() NN_NOEXCEPT;
        nn::Result ListApplyDeltaTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::ApplyDeltaTaskId>& outList) NN_NOEXCEPT;
        nn::Result ClearNotEnoughSpaceStateOfApplyDeltaTask(const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        nn::Result CreateApplyDeltaTaskFromDownloadTask(nn::sf::Out<nn::nim::ApplyDeltaTaskId> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result GetBackgroundApplyDeltaStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT;
        nn::Result GetApplyDeltaTaskRequiredStorage(nn::sf::Out<nn::ncm::StorageId> outValue, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
        nn::Result CalculateNetworkInstallTaskContentsSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::NetworkInstallTaskId& id, const nn::ncm::ContentMetaKey& key, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result PrepareShutdownForSystemUpdate() NN_NOEXCEPT;
        nn::Result FindMaxRequiredApplicationVersionOfTask(nn::sf::Out<std::uint32_t> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result CommitNetworkInstallTaskPartially(const nn::sf::InArray<nn::ncm::StorageContentMetaKey>& list, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result ListNetworkInstallTaskCommittedContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result ListNetworkInstallTaskNotCommittedContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result FindMaxRequiredSystemVersionOfTask(nn::sf::Out<std::uint32_t> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result GetNetworkInstallTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result CreateLocalCommunicationReceiveApplicationTask(nn::sf::Out<nn::nim::LocalCommunicationReceiveApplicationTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, nn::ncm::ApplicationId appId, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storage, nn::Bit32 config) NN_NOEXCEPT;
        nn::Result DestroyLocalCommunicationReceiveApplicationTask(const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
        nn::Result ListLocalCommunicationReceiveApplicationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList) NN_NOEXCEPT;
        nn::Result RequestLocalCommunicationReceiveApplicationTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
        nn::Result GetLocalCommunicationReceiveApplicationTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationReceiveApplicationTaskInfo> outValue, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
        nn::Result CommitLocalCommunicationReceiveApplicationTask(const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
        nn::Result ListLocalCommunicationReceiveApplicationTaskContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
        nn::Result CreateLocalCommunicationSendApplicationTask(nn::sf::Out<nn::nim::LocalCommunicationSendApplicationTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, const nn::sf::InArray<nn::ncm::StorageContentMetaKey>& keyList, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result RequestLocalCommunicationSendApplicationTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;
        nn::Result GetLocalCommunicationReceiveApplicationTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
        nn::Result GetLocalCommunicationSendApplicationTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationSendApplicationTaskInfo> outValue, const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;
        nn::Result DestroyLocalCommunicationSendApplicationTask(const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;
        nn::Result GetLocalCommunicationSendApplicationTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;
        nn::Result CalculateLocalCommunicationReceiveApplicationTaskRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
        nn::Result ListApplicationLocalCommunicationReceiveApplicationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
        nn::Result ListApplicationLocalCommunicationSendApplicationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationSendApplicationTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
        nn::Result CreateLocalCommunicationReceiveSystemUpdateTask(nn::sf::Out<nn::nim::LocalCommunicationReceiveSystemUpdateTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, const nn::ncm::ContentMetaKey& key, nn::Bit32 config) NN_NOEXCEPT;
        nn::Result DestroyLocalCommunicationReceiveSystemUpdateTask(const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result ListLocalCommunicationReceiveSystemUpdateTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationReceiveSystemUpdateTaskId>& outList) NN_NOEXCEPT;
        nn::Result RequestLocalCommunicationReceiveSystemUpdateTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result GetLocalCommunicationReceiveSystemUpdateTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationReceiveSystemUpdateTaskInfo> outValue, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result CommitLocalCommunicationReceiveSystemUpdateTask(const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result GetLocalCommunicationReceiveSystemUpdateTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result CreateLocalCommunicationSendSystemUpdateTask(nn::sf::Out<nn::nim::LocalCommunicationSendSystemUpdateTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
        nn::Result RequestLocalCommunicationSendSystemUpdateTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result GetLocalCommunicationSendSystemUpdateTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationSendSystemUpdateTaskInfo> outValue, const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result DestroyLocalCommunicationSendSystemUpdateTask(const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result GetLocalCommunicationSendSystemUpdateTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;
        nn::Result ListLocalCommunicationSendSystemUpdateTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationSendSystemUpdateTaskId>& outList) NN_NOEXCEPT;
        nn::Result GetReceivedSystemDataPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::SystemDataId dataId, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& taskId) NN_NOEXCEPT;
        nn::Result CalculateApplyDeltaTaskOccupiedSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::ApplyDeltaTaskId& id, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        void ReloadErrorSimulation() NN_NOEXCEPT;
        nn::Result ListNetworkInstallTaskContentMetaFromInstallMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result ListNetworkInstallTaskOccupiedSize(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::InstallTaskOccupiedSize>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
        nn::Result RequestQueryAvailableELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::RightsId>& rightsIds) NN_NOEXCEPT;
        nn::Result RequestAssignELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::RightsId>& rightsIds, nn::nim::ELicenseType licenseType) NN_NOEXCEPT;
        nn::Result RequestExtendELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT;
        nn::Result RequestSyncELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, nn::account::NintendoAccountId naId) NN_NOEXCEPT;
        nn::Result RequestDownloadETickets(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT;
        nn::Result RequestQueryRevokeReason(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outValue, nn::account::NintendoAccountId naId, const nn::es::ELicenseId& eLicenseId) NN_NOEXCEPT;
        nn::Result RequestReportActiveELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, nn::account::NintendoAccountId naId, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT;
        nn::Result RequestReportActiveELicensesPassively(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, nn::account::NintendoAccountId naId, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT;
        nn::Result RequestRegisterDynamicRightsNotificationToken(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::npns::NotificationToken& notificationToken) NN_NOEXCEPT;
        nn::Result RequestAssignAllDeviceLinkedELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateSystemUpdateTask(nn::sf::Out<nn::nim::SystemUpdateTaskId> outValue, const nn::ncm::ContentMetaKey& key, nn::Bit32 config) NN_NOEXCEPT;
    nn::Result DestroySystemUpdateTask(const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result ListSystemUpdateTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::SystemUpdateTaskId>& outList) NN_NOEXCEPT;
    nn::Result RequestSystemUpdateTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result GetSystemUpdateTaskInfo(nn::sf::Out<nn::nim::SystemUpdateTaskInfo> outValue, const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result CommitSystemUpdateTask(const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result CreateNetworkInstallTask(nn::sf::Out<nn::nim::NetworkInstallTaskId> outValue, nn::ncm::ApplicationId appId, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storage, nn::Bit32 config) NN_NOEXCEPT;
    nn::Result DestroyNetworkInstallTask(const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result ListNetworkInstallTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::NetworkInstallTaskId>& outList) NN_NOEXCEPT;
    nn::Result RequestNetworkInstallTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result GetNetworkInstallTaskInfo(nn::sf::Out<nn::nim::NetworkInstallTaskInfo> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result CommitNetworkInstallTask(const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result RequestLatestSystemUpdateMeta(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
    nn::Result ListApplicationNetworkInstallTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::NetworkInstallTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
    nn::Result ListNetworkInstallTaskContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result RequestLatestVersion(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
    nn::Result SetNetworkInstallTaskAttribute(const nn::nim::NetworkInstallTaskIdAttribute& idAttribute) NN_NOEXCEPT;
    nn::Result AddNetworkInstallTaskContentMeta(const nn::sf::InArray<nn::ncm::ContentMetaKey>& list, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result GetDownloadedSystemDataPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::SystemDataId dataId, const nn::nim::SystemUpdateTaskId& taskId) NN_NOEXCEPT;
    nn::Result CalculateNetworkInstallTaskRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result IsExFatDriverIncluded(nn::sf::Out<bool> outValue, const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result GetBackgroundDownloadStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT;
    nn::Result RequestDeviceAuthenticationToken(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
    nn::Result RequestGameCardRegistrationStatus(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, const nn::sf::InArray<nn::ncm::ApplicationId>& appIdList, const nn::sf::InBuffer& token, const nn::sf::InBuffer& cert) NN_NOEXCEPT;
    nn::Result RequestRegisterGameCard(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::sf::InArray<nn::ncm::ApplicationId>& appIdList, const nn::sf::InBuffer& token, const nn::sf::InBuffer& cert, nn::nim::GameCardRegistrationStatus status) NN_NOEXCEPT;
    nn::Result RequestRegisterNotificationToken(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::npns::NotificationToken& notificationToken) NN_NOEXCEPT;
    nn::Result RequestDownloadTaskList(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outAsync, const nn::nim::ETag& eTag) NN_NOEXCEPT;
    nn::Result RequestApplicationControl(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId applicationId, std::uint32_t version) NN_NOEXCEPT;
    nn::Result RequestLatestApplicationControl(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result RequestVersionList(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outAsync, const nn::nim::ETag& eTag) NN_NOEXCEPT;
    nn::Result CreateApplyDeltaTask(nn::sf::Out<nn::nim::ApplyDeltaTaskId> outValue, nn::ncm::ApplicationId appId, const nn::ncm::ContentMetaKey& sourceKey, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result DestroyApplyDeltaTask(const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
    nn::Result ListApplicationApplyDeltaTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::ApplyDeltaTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
    nn::Result RequestApplyDeltaTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
    nn::Result GetApplyDeltaTaskInfo(nn::sf::Out<nn::nim::ApplyDeltaTaskInfo> outValue, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
    nn::Result ListApplyDeltaTaskContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
    nn::Result CommitApplyDeltaTask(const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
    nn::Result CalculateApplyDeltaTaskRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
    nn::Result PrepareShutdown() NN_NOEXCEPT;
    nn::Result ListApplyDeltaTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::ApplyDeltaTaskId>& outList) NN_NOEXCEPT;
    nn::Result ClearNotEnoughSpaceStateOfApplyDeltaTask(const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
    nn::Result CreateApplyDeltaTaskFromDownloadTask(nn::sf::Out<nn::nim::ApplyDeltaTaskId> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result GetBackgroundApplyDeltaStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT;
    nn::Result GetApplyDeltaTaskRequiredStorage(nn::sf::Out<nn::ncm::StorageId> outValue, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT;
    nn::Result CalculateNetworkInstallTaskContentsSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::NetworkInstallTaskId& id, const nn::ncm::ContentMetaKey& key, nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result PrepareShutdownForSystemUpdate() NN_NOEXCEPT;
    nn::Result FindMaxRequiredApplicationVersionOfTask(nn::sf::Out<std::uint32_t> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result CommitNetworkInstallTaskPartially(const nn::sf::InArray<nn::ncm::StorageContentMetaKey>& list, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result ListNetworkInstallTaskCommittedContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result ListNetworkInstallTaskNotCommittedContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result FindMaxRequiredSystemVersionOfTask(nn::sf::Out<std::uint32_t> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result GetNetworkInstallTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result CreateLocalCommunicationReceiveApplicationTask(nn::sf::Out<nn::nim::LocalCommunicationReceiveApplicationTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, nn::ncm::ApplicationId appId, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storage, nn::Bit32 config) NN_NOEXCEPT;
    nn::Result DestroyLocalCommunicationReceiveApplicationTask(const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
    nn::Result ListLocalCommunicationReceiveApplicationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList) NN_NOEXCEPT;
    nn::Result RequestLocalCommunicationReceiveApplicationTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
    nn::Result GetLocalCommunicationReceiveApplicationTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationReceiveApplicationTaskInfo> outValue, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
    nn::Result CommitLocalCommunicationReceiveApplicationTask(const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
    nn::Result ListLocalCommunicationReceiveApplicationTaskContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
    nn::Result CreateLocalCommunicationSendApplicationTask(nn::sf::Out<nn::nim::LocalCommunicationSendApplicationTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, const nn::sf::InArray<nn::ncm::StorageContentMetaKey>& keyList, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result RequestLocalCommunicationSendApplicationTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;
    nn::Result GetLocalCommunicationReceiveApplicationTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
    nn::Result GetLocalCommunicationSendApplicationTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationSendApplicationTaskInfo> outValue, const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;
    nn::Result DestroyLocalCommunicationSendApplicationTask(const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;
    nn::Result GetLocalCommunicationSendApplicationTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT;
    nn::Result CalculateLocalCommunicationReceiveApplicationTaskRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT;
    nn::Result ListApplicationLocalCommunicationReceiveApplicationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
    nn::Result ListApplicationLocalCommunicationSendApplicationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationSendApplicationTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
    nn::Result CreateLocalCommunicationReceiveSystemUpdateTask(nn::sf::Out<nn::nim::LocalCommunicationReceiveSystemUpdateTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, const nn::ncm::ContentMetaKey& key, nn::Bit32 config) NN_NOEXCEPT;
    nn::Result DestroyLocalCommunicationReceiveSystemUpdateTask(const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result ListLocalCommunicationReceiveSystemUpdateTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationReceiveSystemUpdateTaskId>& outList) NN_NOEXCEPT;
    nn::Result RequestLocalCommunicationReceiveSystemUpdateTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result GetLocalCommunicationReceiveSystemUpdateTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationReceiveSystemUpdateTaskInfo> outValue, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result CommitLocalCommunicationReceiveSystemUpdateTask(const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result GetLocalCommunicationReceiveSystemUpdateTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result CreateLocalCommunicationSendSystemUpdateTask(nn::sf::Out<nn::nim::LocalCommunicationSendSystemUpdateTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
    nn::Result RequestLocalCommunicationSendSystemUpdateTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result GetLocalCommunicationSendSystemUpdateTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationSendSystemUpdateTaskInfo> outValue, const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result DestroyLocalCommunicationSendSystemUpdateTask(const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result GetLocalCommunicationSendSystemUpdateTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT;
    nn::Result ListLocalCommunicationSendSystemUpdateTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationSendSystemUpdateTaskId>& outList) NN_NOEXCEPT;
    nn::Result GetReceivedSystemDataPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::SystemDataId dataId, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& taskId) NN_NOEXCEPT;
    nn::Result CalculateApplyDeltaTaskOccupiedSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::ApplyDeltaTaskId& id, nn::ncm::StorageId storageId) NN_NOEXCEPT;
    void ReloadErrorSimulation() NN_NOEXCEPT;
    nn::Result ListNetworkInstallTaskContentMetaFromInstallMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result ListNetworkInstallTaskOccupiedSize(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::InstallTaskOccupiedSize>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT;
    nn::Result RequestQueryAvailableELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::RightsId>& rightsIds) NN_NOEXCEPT;
    nn::Result RequestAssignELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::RightsId>& rightsIds, nn::nim::ELicenseType licenseType) NN_NOEXCEPT;
    nn::Result RequestExtendELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT;
    nn::Result RequestSyncELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, nn::account::NintendoAccountId naId) NN_NOEXCEPT;
    nn::Result RequestDownloadETickets(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT;
    nn::Result RequestQueryRevokeReason(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outValue, nn::account::NintendoAccountId naId, const nn::es::ELicenseId& eLicenseId) NN_NOEXCEPT;
    nn::Result RequestReportActiveELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, nn::account::NintendoAccountId naId, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT;
    nn::Result RequestReportActiveELicensesPassively(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, nn::account::NintendoAccountId naId, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT;
    nn::Result RequestRegisterDynamicRightsNotificationToken(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::npns::NotificationToken& notificationToken) NN_NOEXCEPT;
    nn::Result RequestAssignAllDeviceLinkedELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nim::detail::INetworkInstallManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSystemUpdateTask, (::nn::sf::Out<::nn::nim::SystemUpdateTaskId> outValue, const ::nn::ncm::ContentMetaKey& key, ::nn::Bit32 config))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSystemUpdateTask, (outValue, key, config));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroySystemUpdateTask, (const ::nn::nim::SystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroySystemUpdateTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListSystemUpdateTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::SystemUpdateTaskId>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListSystemUpdateTask, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSystemUpdateTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::SystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestSystemUpdateTaskRun, (outHandle, outAsync, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemUpdateTaskInfo, (::nn::sf::Out<::nn::nim::SystemUpdateTaskInfo> outValue, const ::nn::nim::SystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemUpdateTaskInfo, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitSystemUpdateTask, (const ::nn::nim::SystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CommitSystemUpdateTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateNetworkInstallTask, (::nn::sf::Out<::nn::nim::NetworkInstallTaskId> outValue, ::nn::ncm::ApplicationId appId, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storage, ::nn::Bit32 config))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateNetworkInstallTask, (outValue, appId, keyList, storage, config));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyNetworkInstallTask, (const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyNetworkInstallTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::NetworkInstallTaskId>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListNetworkInstallTask, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestNetworkInstallTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestNetworkInstallTaskRun, (outHandle, outAsync, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkInstallTaskInfo, (::nn::sf::Out<::nn::nim::NetworkInstallTaskInfo> outValue, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNetworkInstallTaskInfo, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitNetworkInstallTask, (const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CommitNetworkInstallTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLatestSystemUpdateMeta, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestLatestSystemUpdateMeta, (outHandle, outAsync));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationNetworkInstallTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::NetworkInstallTaskId>& outList, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationNetworkInstallTask, (outCount, outList, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListNetworkInstallTaskContentMeta, (outCount, outList, offset, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLatestVersion, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestLatestVersion, (outHandle, outAsync, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNetworkInstallTaskAttribute, (const ::nn::nim::NetworkInstallTaskIdAttribute& idAttribute))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetNetworkInstallTaskAttribute, (idAttribute));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddNetworkInstallTaskContentMeta, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& list, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddNetworkInstallTaskContentMeta, (list, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadedSystemDataPath, (::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::SystemDataId dataId, const ::nn::nim::SystemUpdateTaskId& taskId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDownloadedSystemDataPath, (outValue, dataId, taskId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateNetworkInstallTaskRequiredSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CalculateNetworkInstallTaskRequiredSize, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsExFatDriverIncluded, (::nn::sf::Out<bool> outValue, const ::nn::nim::SystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsExFatDriverIncluded, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundDownloadStressTaskInfo, (::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBackgroundDownloadStressTaskInfo, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDeviceAuthenticationToken, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestDeviceAuthenticationToken, (outHandle, outAsync));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestGameCardRegistrationStatus, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& appIdList, const ::nn::sf::InBuffer& token, const ::nn::sf::InBuffer& cert))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestGameCardRegistrationStatus, (outHandle, outAsync, appIdList, token, cert));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestRegisterGameCard, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& appIdList, const ::nn::sf::InBuffer& token, const ::nn::sf::InBuffer& cert, ::nn::nim::GameCardRegistrationStatus status))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestRegisterGameCard, (outHandle, outAsync, appIdList, token, cert, status));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestRegisterNotificationToken, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::npns::NotificationToken& notificationToken))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestRegisterNotificationToken, (outHandle, outAsync, notificationToken));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadTaskList, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outAsync, const ::nn::nim::ETag& eTag))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestDownloadTaskList, (outHandle, outAsync, eTag));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplicationControl, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId applicationId, ::std::uint32_t version))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestApplicationControl, (outHandle, outAsync, applicationId, version));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLatestApplicationControl, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestLatestApplicationControl, (outHandle, outAsync, applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestVersionList, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outAsync, const ::nn::nim::ETag& eTag))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestVersionList, (outHandle, outAsync, eTag));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateApplyDeltaTask, (::nn::sf::Out<::nn::nim::ApplyDeltaTaskId> outValue, ::nn::ncm::ApplicationId appId, const ::nn::ncm::ContentMetaKey& sourceKey, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateApplyDeltaTask, (outValue, appId, sourceKey, keyList, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyApplyDeltaTask, (const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyApplyDeltaTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationApplyDeltaTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::ApplyDeltaTaskId>& outList, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationApplyDeltaTask, (outCount, outList, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplyDeltaTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestApplyDeltaTaskRun, (outHandle, outAsync, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplyDeltaTaskInfo, (::nn::sf::Out<::nn::nim::ApplyDeltaTaskInfo> outValue, const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplyDeltaTaskInfo, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplyDeltaTaskContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplyDeltaTaskContentMeta, (outCount, outList, offset, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitApplyDeltaTask, (const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CommitApplyDeltaTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplyDeltaTaskRequiredSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CalculateApplyDeltaTaskRequiredSize, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PrepareShutdown)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(PrepareShutdown);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplyDeltaTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::ApplyDeltaTaskId>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplyDeltaTask, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearNotEnoughSpaceStateOfApplyDeltaTask, (const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ClearNotEnoughSpaceStateOfApplyDeltaTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateApplyDeltaTaskFromDownloadTask, (::nn::sf::Out<::nn::nim::ApplyDeltaTaskId> outValue, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateApplyDeltaTaskFromDownloadTask, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundApplyDeltaStressTaskInfo, (::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBackgroundApplyDeltaStressTaskInfo, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplyDeltaTaskRequiredStorage, (::nn::sf::Out<::nn::ncm::StorageId> outValue, const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplyDeltaTaskRequiredStorage, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateNetworkInstallTaskContentsSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::NetworkInstallTaskId& id, const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CalculateNetworkInstallTaskContentsSize, (outValue, id, key, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PrepareShutdownForSystemUpdate)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(PrepareShutdownForSystemUpdate);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindMaxRequiredApplicationVersionOfTask, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FindMaxRequiredApplicationVersionOfTask, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitNetworkInstallTaskPartially, (const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>& list, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CommitNetworkInstallTaskPartially, (list, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskCommittedContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListNetworkInstallTaskCommittedContentMeta, (outCount, outList, offset, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskNotCommittedContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListNetworkInstallTaskNotCommittedContentMeta, (outCount, outList, offset, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindMaxRequiredSystemVersionOfTask, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FindMaxRequiredSystemVersionOfTask, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkInstallTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNetworkInstallTaskErrorContext, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateLocalCommunicationReceiveApplicationTask, (::nn::sf::Out<::nn::nim::LocalCommunicationReceiveApplicationTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, ::nn::ncm::ApplicationId appId, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storage, ::nn::Bit32 config))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateLocalCommunicationReceiveApplicationTask, (outValue, ipv4, port, appId, keyList, storage, config));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationReceiveApplicationTask, (const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyLocalCommunicationReceiveApplicationTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListLocalCommunicationReceiveApplicationTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListLocalCommunicationReceiveApplicationTask, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLocalCommunicationReceiveApplicationTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestLocalCommunicationReceiveApplicationTaskRun, (outHandle, outAsync, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveApplicationTaskInfo, (::nn::sf::Out<::nn::nim::LocalCommunicationReceiveApplicationTaskInfo> outValue, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLocalCommunicationReceiveApplicationTaskInfo, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitLocalCommunicationReceiveApplicationTask, (const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CommitLocalCommunicationReceiveApplicationTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListLocalCommunicationReceiveApplicationTaskContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListLocalCommunicationReceiveApplicationTaskContentMeta, (outCount, outList, offset, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateLocalCommunicationSendApplicationTask, (::nn::sf::Out<::nn::nim::LocalCommunicationSendApplicationTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>& keyList, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateLocalCommunicationSendApplicationTask, (outValue, ipv4, port, keyList, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLocalCommunicationSendApplicationTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationSendApplicationTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestLocalCommunicationSendApplicationTaskRun, (outHandle, outAsync, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveApplicationTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLocalCommunicationReceiveApplicationTaskErrorContext, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendApplicationTaskInfo, (::nn::sf::Out<::nn::nim::LocalCommunicationSendApplicationTaskInfo> outValue, const ::nn::nim::LocalCommunicationSendApplicationTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLocalCommunicationSendApplicationTaskInfo, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationSendApplicationTask, (const ::nn::nim::LocalCommunicationSendApplicationTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyLocalCommunicationSendApplicationTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendApplicationTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationSendApplicationTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLocalCommunicationSendApplicationTaskErrorContext, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateLocalCommunicationReceiveApplicationTaskRequiredSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CalculateLocalCommunicationReceiveApplicationTaskRequiredSize, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationLocalCommunicationReceiveApplicationTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationLocalCommunicationReceiveApplicationTask, (outCount, outList, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationLocalCommunicationSendApplicationTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationSendApplicationTaskId>& outList, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationLocalCommunicationSendApplicationTask, (outCount, outList, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateLocalCommunicationReceiveSystemUpdateTask, (::nn::sf::Out<::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ncm::ContentMetaKey& key, ::nn::Bit32 config))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateLocalCommunicationReceiveSystemUpdateTask, (outValue, ipv4, port, key, config));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationReceiveSystemUpdateTask, (const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyLocalCommunicationReceiveSystemUpdateTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListLocalCommunicationReceiveSystemUpdateTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListLocalCommunicationReceiveSystemUpdateTask, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLocalCommunicationReceiveSystemUpdateTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestLocalCommunicationReceiveSystemUpdateTaskRun, (outHandle, outAsync, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveSystemUpdateTaskInfo, (::nn::sf::Out<::nn::nim::LocalCommunicationReceiveSystemUpdateTaskInfo> outValue, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLocalCommunicationReceiveSystemUpdateTaskInfo, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitLocalCommunicationReceiveSystemUpdateTask, (const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CommitLocalCommunicationReceiveSystemUpdateTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveSystemUpdateTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLocalCommunicationReceiveSystemUpdateTaskErrorContext, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateLocalCommunicationSendSystemUpdateTask, (::nn::sf::Out<::nn::nim::LocalCommunicationSendSystemUpdateTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateLocalCommunicationSendSystemUpdateTask, (outValue, ipv4, port, key));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLocalCommunicationSendSystemUpdateTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestLocalCommunicationSendSystemUpdateTaskRun, (outHandle, outAsync, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendSystemUpdateTaskInfo, (::nn::sf::Out<::nn::nim::LocalCommunicationSendSystemUpdateTaskInfo> outValue, const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLocalCommunicationSendSystemUpdateTaskInfo, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationSendSystemUpdateTask, (const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyLocalCommunicationSendSystemUpdateTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendSystemUpdateTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLocalCommunicationSendSystemUpdateTaskErrorContext, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListLocalCommunicationSendSystemUpdateTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationSendSystemUpdateTaskId>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListLocalCommunicationSendSystemUpdateTask, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivedSystemDataPath, (::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::SystemDataId dataId, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& taskId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReceivedSystemDataPath, (outValue, dataId, taskId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplyDeltaTaskOccupiedSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::ApplyDeltaTaskId& id, ::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CalculateApplyDeltaTaskOccupiedSize, (outValue, id, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(ReloadErrorSimulation)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(ReloadErrorSimulation);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskContentMetaFromInstallMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListNetworkInstallTaskContentMetaFromInstallMeta, (outCount, outList, offset, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskOccupiedSize, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::InstallTaskOccupiedSize>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListNetworkInstallTaskOccupiedSize, (outCount, outList, offset, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestQueryAvailableELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestQueryAvailableELicenses, (outHandle, outValue, uid, rightsIds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestAssignELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIds, ::nn::nim::ELicenseType licenseType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestAssignELicenses, (outHandle, outValue, uid, rightsIds, licenseType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestExtendELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestExtendELicenses, (outHandle, outValue, uid, elicenseIds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, ::nn::account::NintendoAccountId naId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestSyncELicenses, (outHandle, outValue, naId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadETickets, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestDownloadETickets, (outHandle, outValue, uid, elicenseIds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestQueryRevokeReason, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outValue, ::nn::account::NintendoAccountId naId, const ::nn::es::ELicenseId& eLicenseId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestQueryRevokeReason, (outHandle, outValue, naId, eLicenseId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestReportActiveELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, ::nn::account::NintendoAccountId naId, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestReportActiveELicenses, (outHandle, outValue, naId, elicenseIds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestReportActiveELicensesPassively, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, ::nn::account::NintendoAccountId naId, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestReportActiveELicensesPassively, (outHandle, outValue, naId, elicenseIds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestRegisterDynamicRightsNotificationToken, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::npns::NotificationToken& notificationToken))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestRegisterDynamicRightsNotificationToken, (outHandle, outAsync, notificationToken));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestAssignAllDeviceLinkedELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestAssignAllDeviceLinkedELicenses, (outHandle, outValue));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nim::detail::INetworkInstallManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nim::detail::INetworkInstallManager))

    // nn::Result CreateSystemUpdateTask(nn::sf::Out<nn::nim::SystemUpdateTaskId> outValue, const nn::ncm::ContentMetaKey& key, nn::Bit32 config) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSystemUpdateTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(config, (::nn::Bit32), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (config, key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::SystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(config)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSystemUpdateTask)

    // nn::Result DestroySystemUpdateTask(const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroySystemUpdateTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::SystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroySystemUpdateTask)

    // nn::Result ListSystemUpdateTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::SystemUpdateTaskId>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListSystemUpdateTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::nim::SystemUpdateTaskId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListSystemUpdateTask)

    // nn::Result RequestSystemUpdateTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestSystemUpdateTaskRun)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::SystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestSystemUpdateTaskRun)

    // nn::Result GetSystemUpdateTaskInfo(nn::sf::Out<nn::nim::SystemUpdateTaskInfo> outValue, const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemUpdateTaskInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::SystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::SystemUpdateTaskInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemUpdateTaskInfo)

    // nn::Result CommitSystemUpdateTask(const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CommitSystemUpdateTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::SystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CommitSystemUpdateTask)

    // nn::Result CreateNetworkInstallTask(nn::sf::Out<nn::nim::NetworkInstallTaskId> outValue, nn::ncm::ApplicationId appId, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storage, nn::Bit32 config) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateNetworkInstallTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(keyList, 0, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (keyList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(config, (::nn::Bit32), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (storage, config, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::NetworkInstallTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keyList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(config)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateNetworkInstallTask)

    // nn::Result DestroyNetworkInstallTask(const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyNetworkInstallTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyNetworkInstallTask)

    // nn::Result ListNetworkInstallTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::NetworkInstallTaskId>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListNetworkInstallTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::nim::NetworkInstallTaskId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListNetworkInstallTask)

    // nn::Result RequestNetworkInstallTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestNetworkInstallTaskRun)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestNetworkInstallTaskRun)

    // nn::Result GetNetworkInstallTaskInfo(nn::sf::Out<nn::nim::NetworkInstallTaskInfo> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNetworkInstallTaskInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::NetworkInstallTaskInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNetworkInstallTaskInfo)

    // nn::Result CommitNetworkInstallTask(const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CommitNetworkInstallTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CommitNetworkInstallTask)

    // nn::Result RequestLatestSystemUpdateMeta(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestLatestSystemUpdateMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestLatestSystemUpdateMeta)

    // nn::Result ListApplicationNetworkInstallTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::NetworkInstallTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationNetworkInstallTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::nim::NetworkInstallTaskId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationNetworkInstallTask)

    // nn::Result ListNetworkInstallTaskContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListNetworkInstallTaskContentMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListNetworkInstallTaskContentMeta)

    // nn::Result RequestLatestVersion(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestLatestVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestLatestVersion)

    // nn::Result SetNetworkInstallTaskAttribute(const nn::nim::NetworkInstallTaskIdAttribute& idAttribute) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetNetworkInstallTaskAttribute)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(idAttribute, (::nn::nim::NetworkInstallTaskIdAttribute), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (idAttribute))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(idAttribute)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetNetworkInstallTaskAttribute)

    // nn::Result AddNetworkInstallTaskContentMeta(const nn::sf::InArray<nn::ncm::ContentMetaKey>& list, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddNetworkInstallTaskContentMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(list, 0, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (list))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(list), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddNetworkInstallTaskContentMeta)

    // nn::Result GetDownloadedSystemDataPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::SystemDataId dataId, const nn::nim::SystemUpdateTaskId& taskId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDownloadedSystemDataPath)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::ncm::Path>), 768, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dataId, (::nn::ncm::SystemDataId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(taskId, (::nn::nim::SystemUpdateTaskId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (dataId, taskId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(taskId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDownloadedSystemDataPath)

    // nn::Result CalculateNetworkInstallTaskRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CalculateNetworkInstallTaskRequiredSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CalculateNetworkInstallTaskRequiredSize)

    // nn::Result IsExFatDriverIncluded(nn::sf::Out<bool> outValue, const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsExFatDriverIncluded)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::SystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsExFatDriverIncluded)

    // nn::Result GetBackgroundDownloadStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBackgroundDownloadStressTaskInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::BackgroundDownloadStressTaskInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBackgroundDownloadStressTaskInfo)

    // nn::Result RequestDeviceAuthenticationToken(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestDeviceAuthenticationToken)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestDeviceAuthenticationToken)

    // nn::Result RequestGameCardRegistrationStatus(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, const nn::sf::InArray<nn::ncm::ApplicationId>& appIdList, const nn::sf::InBuffer& token, const nn::sf::InBuffer& cert) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestGameCardRegistrationStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(appIdList, 0, (const ::nn::sf::InArray<::nn::ncm::ApplicationId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(token, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(cert, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (appIdList, token, cert))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appIdList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(token), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(cert)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestGameCardRegistrationStatus)

    // nn::Result RequestRegisterGameCard(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::sf::InArray<nn::ncm::ApplicationId>& appIdList, const nn::sf::InBuffer& token, const nn::sf::InBuffer& cert, nn::nim::GameCardRegistrationStatus status) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestRegisterGameCard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(appIdList, 0, (const ::nn::sf::InArray<::nn::ncm::ApplicationId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(token, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(cert, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (appIdList, token, cert))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(status, (::nn::nim::GameCardRegistrationStatus), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (status))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appIdList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(token), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(cert), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(status)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestRegisterGameCard)

    // nn::Result RequestRegisterNotificationToken(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::npns::NotificationToken& notificationToken) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestRegisterNotificationToken)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(notificationToken, (::nn::npns::NotificationToken), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (notificationToken))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(notificationToken)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestRegisterNotificationToken)

    // nn::Result RequestDownloadTaskList(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outAsync, const nn::nim::ETag& eTag) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestDownloadTaskList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eTag, (::nn::nim::ETag), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (eTag))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eTag)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestDownloadTaskList)

    // nn::Result RequestApplicationControl(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId applicationId, std::uint32_t version) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestApplicationControl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (version, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestApplicationControl)

    // nn::Result RequestLatestApplicationControl(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestLatestApplicationControl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(29)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestLatestApplicationControl)

    // nn::Result RequestVersionList(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outAsync, const nn::nim::ETag& eTag) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestVersionList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eTag, (::nn::nim::ETag), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (eTag))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eTag)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestVersionList)

    // nn::Result CreateApplyDeltaTask(nn::sf::Out<nn::nim::ApplyDeltaTaskId> outValue, nn::ncm::ApplicationId appId, const nn::ncm::ContentMetaKey& sourceKey, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateApplyDeltaTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(keyList, 0, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (keyList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceKey, (::nn::ncm::ContentMetaKey), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (storageId, appId, sourceKey))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::ApplyDeltaTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keyList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateApplyDeltaTask)

    // nn::Result DestroyApplyDeltaTask(const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyApplyDeltaTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::ApplyDeltaTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyApplyDeltaTask)

    // nn::Result ListApplicationApplyDeltaTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::ApplyDeltaTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationApplyDeltaTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(33)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::nim::ApplyDeltaTaskId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationApplyDeltaTask)

    // nn::Result RequestApplyDeltaTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestApplyDeltaTaskRun)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(34)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::ApplyDeltaTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestApplyDeltaTaskRun)

    // nn::Result GetApplyDeltaTaskInfo(nn::sf::Out<nn::nim::ApplyDeltaTaskInfo> outValue, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplyDeltaTaskInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(35)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::ApplyDeltaTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::ApplyDeltaTaskInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplyDeltaTaskInfo)

    // nn::Result ListApplyDeltaTaskContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplyDeltaTaskContentMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(36)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::ApplyDeltaTaskId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplyDeltaTaskContentMeta)

    // nn::Result CommitApplyDeltaTask(const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CommitApplyDeltaTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(37)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::ApplyDeltaTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CommitApplyDeltaTask)

    // nn::Result CalculateApplyDeltaTaskRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CalculateApplyDeltaTaskRequiredSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(38)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::ApplyDeltaTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CalculateApplyDeltaTaskRequiredSize)

    // nn::Result PrepareShutdown() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PrepareShutdown)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(39)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PrepareShutdown)

    // nn::Result ListApplyDeltaTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::ApplyDeltaTaskId>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplyDeltaTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::nim::ApplyDeltaTaskId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplyDeltaTask)

    // nn::Result ClearNotEnoughSpaceStateOfApplyDeltaTask(const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearNotEnoughSpaceStateOfApplyDeltaTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(41)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::ApplyDeltaTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearNotEnoughSpaceStateOfApplyDeltaTask)

    // nn::Result CreateApplyDeltaTaskFromDownloadTask(nn::sf::Out<nn::nim::ApplyDeltaTaskId> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateApplyDeltaTaskFromDownloadTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(42)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::ApplyDeltaTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateApplyDeltaTaskFromDownloadTask)

    // nn::Result GetBackgroundApplyDeltaStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBackgroundApplyDeltaStressTaskInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(43)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::BackgroundDownloadStressTaskInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBackgroundApplyDeltaStressTaskInfo)

    // nn::Result GetApplyDeltaTaskRequiredStorage(nn::sf::Out<nn::ncm::StorageId> outValue, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplyDeltaTaskRequiredStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(44)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::ApplyDeltaTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplyDeltaTaskRequiredStorage)

    // nn::Result CalculateNetworkInstallTaskContentsSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::NetworkInstallTaskId& id, const nn::ncm::ContentMetaKey& key, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CalculateNetworkInstallTaskContentsSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(45)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (id, storageId, key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CalculateNetworkInstallTaskContentsSize)

    // nn::Result PrepareShutdownForSystemUpdate() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PrepareShutdownForSystemUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(46)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PrepareShutdownForSystemUpdate)

    // nn::Result FindMaxRequiredApplicationVersionOfTask(nn::sf::Out<std::uint32_t> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FindMaxRequiredApplicationVersionOfTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(47)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FindMaxRequiredApplicationVersionOfTask)

    // nn::Result CommitNetworkInstallTaskPartially(const nn::sf::InArray<nn::ncm::StorageContentMetaKey>& list, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CommitNetworkInstallTaskPartially)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(list, 0, (const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (list))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(list), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CommitNetworkInstallTaskPartially)

    // nn::Result ListNetworkInstallTaskCommittedContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListNetworkInstallTaskCommittedContentMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(49)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListNetworkInstallTaskCommittedContentMeta)

    // nn::Result ListNetworkInstallTaskNotCommittedContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListNetworkInstallTaskNotCommittedContentMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(50)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListNetworkInstallTaskNotCommittedContentMeta)

    // nn::Result FindMaxRequiredSystemVersionOfTask(nn::sf::Out<std::uint32_t> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FindMaxRequiredSystemVersionOfTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(51)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FindMaxRequiredSystemVersionOfTask)

    // nn::Result GetNetworkInstallTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNetworkInstallTaskErrorContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(52)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::err::ErrorContext>), 512, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNetworkInstallTaskErrorContext)

    // nn::Result CreateLocalCommunicationReceiveApplicationTask(nn::sf::Out<nn::nim::LocalCommunicationReceiveApplicationTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, nn::ncm::ApplicationId appId, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storage, nn::Bit32 config) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateLocalCommunicationReceiveApplicationTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(53)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(keyList, 0, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (keyList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(port, (::std::uint16_t), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ipv4, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(config, (::nn::Bit32), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (storage, port, ipv4, config, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::LocalCommunicationReceiveApplicationTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ipv4), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(port), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keyList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(config)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateLocalCommunicationReceiveApplicationTask)

    // nn::Result DestroyLocalCommunicationReceiveApplicationTask(const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyLocalCommunicationReceiveApplicationTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(54)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationReceiveApplicationTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyLocalCommunicationReceiveApplicationTask)

    // nn::Result ListLocalCommunicationReceiveApplicationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListLocalCommunicationReceiveApplicationTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(55)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveApplicationTaskId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListLocalCommunicationReceiveApplicationTask)

    // nn::Result RequestLocalCommunicationReceiveApplicationTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestLocalCommunicationReceiveApplicationTaskRun)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationReceiveApplicationTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestLocalCommunicationReceiveApplicationTaskRun)

    // nn::Result GetLocalCommunicationReceiveApplicationTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationReceiveApplicationTaskInfo> outValue, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLocalCommunicationReceiveApplicationTaskInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(57)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationReceiveApplicationTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::LocalCommunicationReceiveApplicationTaskInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLocalCommunicationReceiveApplicationTaskInfo)

    // nn::Result CommitLocalCommunicationReceiveApplicationTask(const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CommitLocalCommunicationReceiveApplicationTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(58)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationReceiveApplicationTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CommitLocalCommunicationReceiveApplicationTask)

    // nn::Result ListLocalCommunicationReceiveApplicationTaskContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListLocalCommunicationReceiveApplicationTaskContentMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(59)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationReceiveApplicationTaskId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListLocalCommunicationReceiveApplicationTaskContentMeta)

    // nn::Result CreateLocalCommunicationSendApplicationTask(nn::sf::Out<nn::nim::LocalCommunicationSendApplicationTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, const nn::sf::InArray<nn::ncm::StorageContentMetaKey>& keyList, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateLocalCommunicationSendApplicationTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(60)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(keyList, 0, (const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (keyList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(port, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ipv4, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (port, ipv4, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::LocalCommunicationSendApplicationTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ipv4), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(port), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keyList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateLocalCommunicationSendApplicationTask)

    // nn::Result RequestLocalCommunicationSendApplicationTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestLocalCommunicationSendApplicationTaskRun)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(61)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationSendApplicationTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestLocalCommunicationSendApplicationTaskRun)

    // nn::Result GetLocalCommunicationReceiveApplicationTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLocalCommunicationReceiveApplicationTaskErrorContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(62)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::err::ErrorContext>), 512, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationReceiveApplicationTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLocalCommunicationReceiveApplicationTaskErrorContext)

    // nn::Result GetLocalCommunicationSendApplicationTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationSendApplicationTaskInfo> outValue, const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLocalCommunicationSendApplicationTaskInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(63)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationSendApplicationTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::LocalCommunicationSendApplicationTaskInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLocalCommunicationSendApplicationTaskInfo)

    // nn::Result DestroyLocalCommunicationSendApplicationTask(const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyLocalCommunicationSendApplicationTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(64)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationSendApplicationTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyLocalCommunicationSendApplicationTask)

    // nn::Result GetLocalCommunicationSendApplicationTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLocalCommunicationSendApplicationTaskErrorContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(65)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::err::ErrorContext>), 512, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationSendApplicationTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLocalCommunicationSendApplicationTaskErrorContext)

    // nn::Result CalculateLocalCommunicationReceiveApplicationTaskRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CalculateLocalCommunicationReceiveApplicationTaskRequiredSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(66)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationReceiveApplicationTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CalculateLocalCommunicationReceiveApplicationTaskRequiredSize)

    // nn::Result ListApplicationLocalCommunicationReceiveApplicationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationLocalCommunicationReceiveApplicationTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(67)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveApplicationTaskId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationLocalCommunicationReceiveApplicationTask)

    // nn::Result ListApplicationLocalCommunicationSendApplicationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationSendApplicationTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationLocalCommunicationSendApplicationTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(68)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::nim::LocalCommunicationSendApplicationTaskId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationLocalCommunicationSendApplicationTask)

    // nn::Result CreateLocalCommunicationReceiveSystemUpdateTask(nn::sf::Out<nn::nim::LocalCommunicationReceiveSystemUpdateTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, const nn::ncm::ContentMetaKey& key, nn::Bit32 config) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateLocalCommunicationReceiveSystemUpdateTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(69)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(port, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ipv4, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(config, (::nn::Bit32), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (port, ipv4, config, key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ipv4), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(port), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(config)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateLocalCommunicationReceiveSystemUpdateTask)

    // nn::Result DestroyLocalCommunicationReceiveSystemUpdateTask(const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyLocalCommunicationReceiveSystemUpdateTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(70)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyLocalCommunicationReceiveSystemUpdateTask)

    // nn::Result ListLocalCommunicationReceiveSystemUpdateTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationReceiveSystemUpdateTaskId>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListLocalCommunicationReceiveSystemUpdateTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(71)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListLocalCommunicationReceiveSystemUpdateTask)

    // nn::Result RequestLocalCommunicationReceiveSystemUpdateTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestLocalCommunicationReceiveSystemUpdateTaskRun)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestLocalCommunicationReceiveSystemUpdateTaskRun)

    // nn::Result GetLocalCommunicationReceiveSystemUpdateTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationReceiveSystemUpdateTaskInfo> outValue, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLocalCommunicationReceiveSystemUpdateTaskInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(73)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::LocalCommunicationReceiveSystemUpdateTaskInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLocalCommunicationReceiveSystemUpdateTaskInfo)

    // nn::Result CommitLocalCommunicationReceiveSystemUpdateTask(const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CommitLocalCommunicationReceiveSystemUpdateTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(74)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CommitLocalCommunicationReceiveSystemUpdateTask)

    // nn::Result GetLocalCommunicationReceiveSystemUpdateTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLocalCommunicationReceiveSystemUpdateTaskErrorContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(75)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::err::ErrorContext>), 512, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLocalCommunicationReceiveSystemUpdateTaskErrorContext)

    // nn::Result CreateLocalCommunicationSendSystemUpdateTask(nn::sf::Out<nn::nim::LocalCommunicationSendSystemUpdateTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateLocalCommunicationSendSystemUpdateTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(76)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(port, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ipv4, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (port, ipv4, key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::LocalCommunicationSendSystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ipv4), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(port), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateLocalCommunicationSendSystemUpdateTask)

    // nn::Result RequestLocalCommunicationSendSystemUpdateTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestLocalCommunicationSendSystemUpdateTaskRun)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(77)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationSendSystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestLocalCommunicationSendSystemUpdateTaskRun)

    // nn::Result GetLocalCommunicationSendSystemUpdateTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationSendSystemUpdateTaskInfo> outValue, const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLocalCommunicationSendSystemUpdateTaskInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(78)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationSendSystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::LocalCommunicationSendSystemUpdateTaskInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLocalCommunicationSendSystemUpdateTaskInfo)

    // nn::Result DestroyLocalCommunicationSendSystemUpdateTask(const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyLocalCommunicationSendSystemUpdateTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(79)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationSendSystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyLocalCommunicationSendSystemUpdateTask)

    // nn::Result GetLocalCommunicationSendSystemUpdateTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLocalCommunicationSendSystemUpdateTaskErrorContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(80)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::err::ErrorContext>), 512, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::LocalCommunicationSendSystemUpdateTaskId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLocalCommunicationSendSystemUpdateTaskErrorContext)

    // nn::Result ListLocalCommunicationSendSystemUpdateTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationSendSystemUpdateTaskId>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListLocalCommunicationSendSystemUpdateTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(81)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::nim::LocalCommunicationSendSystemUpdateTaskId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListLocalCommunicationSendSystemUpdateTask)

    // nn::Result GetReceivedSystemDataPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::SystemDataId dataId, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& taskId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReceivedSystemDataPath)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(82)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::ncm::Path>), 768, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(taskId, (::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dataId, (::nn::ncm::SystemDataId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (taskId, dataId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(taskId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReceivedSystemDataPath)

    // nn::Result CalculateApplyDeltaTaskOccupiedSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::ApplyDeltaTaskId& id, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CalculateApplyDeltaTaskOccupiedSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(83)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::ApplyDeltaTaskId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, storageId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(17)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CalculateApplyDeltaTaskOccupiedSize)

    // void ReloadErrorSimulation() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReloadErrorSimulation)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(84)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReloadErrorSimulation)

    // nn::Result ListNetworkInstallTaskContentMetaFromInstallMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListNetworkInstallTaskContentMetaFromInstallMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(85)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListNetworkInstallTaskContentMetaFromInstallMeta)

    // nn::Result ListNetworkInstallTaskOccupiedSize(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::InstallTaskOccupiedSize>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListNetworkInstallTaskOccupiedSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(86)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::InstallTaskOccupiedSize>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::nim::NetworkInstallTaskId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListNetworkInstallTaskOccupiedSize)

    // nn::Result RequestQueryAvailableELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::RightsId>& rightsIds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestQueryAvailableELicenses)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(87)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(rightsIds, 0, (const ::nn::sf::InArray<::nn::es::RightsId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (rightsIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsIds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestQueryAvailableELicenses)

    // nn::Result RequestAssignELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::RightsId>& rightsIds, nn::nim::ELicenseType licenseType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestAssignELicenses)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(88)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(rightsIds, 0, (const ::nn::sf::InArray<::nn::es::RightsId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (rightsIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(licenseType, (::nn::nim::ELicenseType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (licenseType, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rightsIds), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(licenseType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestAssignELicenses)

    // nn::Result RequestExtendELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestExtendELicenses)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(89)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(elicenseIds, 0, (const ::nn::sf::InArray<::nn::es::ELicenseId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (elicenseIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(elicenseIds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestExtendELicenses)

    // nn::Result RequestSyncELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, nn::account::NintendoAccountId naId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestSyncELicenses)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(90)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(naId, (::nn::account::NintendoAccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (naId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(naId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestSyncELicenses)

    // nn::Result RequestDownloadETickets(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestDownloadETickets)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(91)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(elicenseIds, 0, (const ::nn::sf::InArray<::nn::es::ELicenseId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (elicenseIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(elicenseIds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestDownloadETickets)

    // nn::Result RequestQueryRevokeReason(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outValue, nn::account::NintendoAccountId naId, const nn::es::ELicenseId& eLicenseId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestQueryRevokeReason)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(92)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eLicenseId, (::nn::es::ELicenseId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(naId, (::nn::account::NintendoAccountId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (eLicenseId, naId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(naId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eLicenseId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestQueryRevokeReason)

    // nn::Result RequestReportActiveELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, nn::account::NintendoAccountId naId, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestReportActiveELicenses)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(93)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(elicenseIds, 0, (const ::nn::sf::InArray<::nn::es::ELicenseId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (elicenseIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(naId, (::nn::account::NintendoAccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (naId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(naId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(elicenseIds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestReportActiveELicenses)

    // nn::Result RequestReportActiveELicensesPassively(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, nn::account::NintendoAccountId naId, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestReportActiveELicensesPassively)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(94)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(elicenseIds, 0, (const ::nn::sf::InArray<::nn::es::ELicenseId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (elicenseIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(naId, (::nn::account::NintendoAccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (naId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(naId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(elicenseIds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestReportActiveELicensesPassively)

    // nn::Result RequestRegisterDynamicRightsNotificationToken(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::npns::NotificationToken& notificationToken) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestRegisterDynamicRightsNotificationToken)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(95)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(notificationToken, (::nn::npns::NotificationToken), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (notificationToken))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(notificationToken)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestRegisterDynamicRightsNotificationToken)

    // nn::Result RequestAssignAllDeviceLinkedELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestAssignAllDeviceLinkedELicenses)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(96)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestAssignAllDeviceLinkedELicenses)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::SystemUpdateTaskId), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ContentMetaKey), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::SystemUpdateTaskInfo), 64, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::NetworkInstallTaskId), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::StorageId), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::NetworkInstallTaskInfo), 64, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::StorageContentMetaKey), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::NetworkInstallTaskIdAttribute), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::Path), 768, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::SystemDataId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::BackgroundDownloadStressTaskInfo), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::GameCardRegistrationStatus), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::npns::NotificationToken), 40, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::ETag), 40, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::ApplyDeltaTaskId), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::ApplyDeltaTaskInfo), 48, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::err::ErrorContext), 512, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::LocalCommunicationReceiveApplicationTaskId), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::LocalCommunicationReceiveApplicationTaskInfo), 56, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::LocalCommunicationSendApplicationTaskId), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::LocalCommunicationSendApplicationTaskInfo), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::LocalCommunicationReceiveSystemUpdateTaskInfo), 56, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::LocalCommunicationSendSystemUpdateTaskId), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::LocalCommunicationSendSystemUpdateTaskInfo), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::InstallTaskOccupiedSize), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::RightsId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::ELicenseType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::ELicenseId), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NintendoAccountId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nim::detail::INetworkInstallManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nim::detail::INetworkInstallManager))

    // nn::Result CreateSystemUpdateTask(nn::sf::Out<nn::nim::SystemUpdateTaskId> outValue, const nn::ncm::ContentMetaKey& key, nn::Bit32 config) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSystemUpdateTask, (::nn::sf::Out<::nn::nim::SystemUpdateTaskId> outValue, const ::nn::ncm::ContentMetaKey& key, ::nn::Bit32 config))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSystemUpdateTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(config)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSystemUpdateTask)
    }

    // nn::Result DestroySystemUpdateTask(const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroySystemUpdateTask, (const ::nn::nim::SystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroySystemUpdateTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroySystemUpdateTask)
    }

    // nn::Result ListSystemUpdateTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::SystemUpdateTaskId>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListSystemUpdateTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::SystemUpdateTaskId>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListSystemUpdateTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListSystemUpdateTask)
    }

    // nn::Result RequestSystemUpdateTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSystemUpdateTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::SystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestSystemUpdateTaskRun)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestSystemUpdateTaskRun)
    }

    // nn::Result GetSystemUpdateTaskInfo(nn::sf::Out<nn::nim::SystemUpdateTaskInfo> outValue, const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemUpdateTaskInfo, (::nn::sf::Out<::nn::nim::SystemUpdateTaskInfo> outValue, const ::nn::nim::SystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemUpdateTaskInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemUpdateTaskInfo)
    }

    // nn::Result CommitSystemUpdateTask(const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitSystemUpdateTask, (const ::nn::nim::SystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CommitSystemUpdateTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CommitSystemUpdateTask)
    }

    // nn::Result CreateNetworkInstallTask(nn::sf::Out<nn::nim::NetworkInstallTaskId> outValue, nn::ncm::ApplicationId appId, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storage, nn::Bit32 config) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateNetworkInstallTask, (::nn::sf::Out<::nn::nim::NetworkInstallTaskId> outValue, ::nn::ncm::ApplicationId appId, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storage, ::nn::Bit32 config))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateNetworkInstallTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keyList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(config)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateNetworkInstallTask)
    }

    // nn::Result DestroyNetworkInstallTask(const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyNetworkInstallTask, (const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyNetworkInstallTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyNetworkInstallTask)
    }

    // nn::Result ListNetworkInstallTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::NetworkInstallTaskId>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::NetworkInstallTaskId>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListNetworkInstallTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListNetworkInstallTask)
    }

    // nn::Result RequestNetworkInstallTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestNetworkInstallTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestNetworkInstallTaskRun)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestNetworkInstallTaskRun)
    }

    // nn::Result GetNetworkInstallTaskInfo(nn::sf::Out<nn::nim::NetworkInstallTaskInfo> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkInstallTaskInfo, (::nn::sf::Out<::nn::nim::NetworkInstallTaskInfo> outValue, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNetworkInstallTaskInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNetworkInstallTaskInfo)
    }

    // nn::Result CommitNetworkInstallTask(const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitNetworkInstallTask, (const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CommitNetworkInstallTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CommitNetworkInstallTask)
    }

    // nn::Result RequestLatestSystemUpdateMeta(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLatestSystemUpdateMeta, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestLatestSystemUpdateMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestLatestSystemUpdateMeta)
    }

    // nn::Result ListApplicationNetworkInstallTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::NetworkInstallTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationNetworkInstallTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::NetworkInstallTaskId>& outList, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationNetworkInstallTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationNetworkInstallTask)
    }

    // nn::Result ListNetworkInstallTaskContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListNetworkInstallTaskContentMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListNetworkInstallTaskContentMeta)
    }

    // nn::Result RequestLatestVersion(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLatestVersion, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestLatestVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestLatestVersion)
    }

    // nn::Result SetNetworkInstallTaskAttribute(const nn::nim::NetworkInstallTaskIdAttribute& idAttribute) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNetworkInstallTaskAttribute, (const ::nn::nim::NetworkInstallTaskIdAttribute& idAttribute))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetNetworkInstallTaskAttribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(idAttribute)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetNetworkInstallTaskAttribute)
    }

    // nn::Result AddNetworkInstallTaskContentMeta(const nn::sf::InArray<nn::ncm::ContentMetaKey>& list, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddNetworkInstallTaskContentMeta, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& list, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddNetworkInstallTaskContentMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(list)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddNetworkInstallTaskContentMeta)
    }

    // nn::Result GetDownloadedSystemDataPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::SystemDataId dataId, const nn::nim::SystemUpdateTaskId& taskId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadedSystemDataPath, (::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::SystemDataId dataId, const ::nn::nim::SystemUpdateTaskId& taskId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDownloadedSystemDataPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(taskId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDownloadedSystemDataPath)
    }

    // nn::Result CalculateNetworkInstallTaskRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateNetworkInstallTaskRequiredSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CalculateNetworkInstallTaskRequiredSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CalculateNetworkInstallTaskRequiredSize)
    }

    // nn::Result IsExFatDriverIncluded(nn::sf::Out<bool> outValue, const nn::nim::SystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsExFatDriverIncluded, (::nn::sf::Out<bool> outValue, const ::nn::nim::SystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsExFatDriverIncluded)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsExFatDriverIncluded)
    }

    // nn::Result GetBackgroundDownloadStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundDownloadStressTaskInfo, (::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBackgroundDownloadStressTaskInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBackgroundDownloadStressTaskInfo)
    }

    // nn::Result RequestDeviceAuthenticationToken(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDeviceAuthenticationToken, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestDeviceAuthenticationToken)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestDeviceAuthenticationToken)
    }

    // nn::Result RequestGameCardRegistrationStatus(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, const nn::sf::InArray<nn::ncm::ApplicationId>& appIdList, const nn::sf::InBuffer& token, const nn::sf::InBuffer& cert) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestGameCardRegistrationStatus, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& appIdList, const ::nn::sf::InBuffer& token, const ::nn::sf::InBuffer& cert))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestGameCardRegistrationStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(token)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(cert)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestGameCardRegistrationStatus)
    }

    // nn::Result RequestRegisterGameCard(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::sf::InArray<nn::ncm::ApplicationId>& appIdList, const nn::sf::InBuffer& token, const nn::sf::InBuffer& cert, nn::nim::GameCardRegistrationStatus status) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestRegisterGameCard, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& appIdList, const ::nn::sf::InBuffer& token, const ::nn::sf::InBuffer& cert, ::nn::nim::GameCardRegistrationStatus status))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestRegisterGameCard)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(token)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(cert)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(status)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestRegisterGameCard)
    }

    // nn::Result RequestRegisterNotificationToken(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::npns::NotificationToken& notificationToken) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestRegisterNotificationToken, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::npns::NotificationToken& notificationToken))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestRegisterNotificationToken)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(notificationToken)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestRegisterNotificationToken)
    }

    // nn::Result RequestDownloadTaskList(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outAsync, const nn::nim::ETag& eTag) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadTaskList, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outAsync, const ::nn::nim::ETag& eTag))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestDownloadTaskList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eTag)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestDownloadTaskList)
    }

    // nn::Result RequestApplicationControl(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId applicationId, std::uint32_t version) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplicationControl, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId applicationId, ::std::uint32_t version))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestApplicationControl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestApplicationControl)
    }

    // nn::Result RequestLatestApplicationControl(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLatestApplicationControl, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestLatestApplicationControl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestLatestApplicationControl)
    }

    // nn::Result RequestVersionList(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outAsync, const nn::nim::ETag& eTag) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestVersionList, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outAsync, const ::nn::nim::ETag& eTag))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestVersionList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eTag)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestVersionList)
    }

    // nn::Result CreateApplyDeltaTask(nn::sf::Out<nn::nim::ApplyDeltaTaskId> outValue, nn::ncm::ApplicationId appId, const nn::ncm::ContentMetaKey& sourceKey, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateApplyDeltaTask, (::nn::sf::Out<::nn::nim::ApplyDeltaTaskId> outValue, ::nn::ncm::ApplicationId appId, const ::nn::ncm::ContentMetaKey& sourceKey, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateApplyDeltaTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keyList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateApplyDeltaTask)
    }

    // nn::Result DestroyApplyDeltaTask(const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyApplyDeltaTask, (const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyApplyDeltaTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyApplyDeltaTask)
    }

    // nn::Result ListApplicationApplyDeltaTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::ApplyDeltaTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationApplyDeltaTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::ApplyDeltaTaskId>& outList, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationApplyDeltaTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationApplyDeltaTask)
    }

    // nn::Result RequestApplyDeltaTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplyDeltaTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestApplyDeltaTaskRun)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestApplyDeltaTaskRun)
    }

    // nn::Result GetApplyDeltaTaskInfo(nn::sf::Out<nn::nim::ApplyDeltaTaskInfo> outValue, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplyDeltaTaskInfo, (::nn::sf::Out<::nn::nim::ApplyDeltaTaskInfo> outValue, const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplyDeltaTaskInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplyDeltaTaskInfo)
    }

    // nn::Result ListApplyDeltaTaskContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplyDeltaTaskContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplyDeltaTaskContentMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplyDeltaTaskContentMeta)
    }

    // nn::Result CommitApplyDeltaTask(const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitApplyDeltaTask, (const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CommitApplyDeltaTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CommitApplyDeltaTask)
    }

    // nn::Result CalculateApplyDeltaTaskRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplyDeltaTaskRequiredSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CalculateApplyDeltaTaskRequiredSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CalculateApplyDeltaTaskRequiredSize)
    }

    // nn::Result PrepareShutdown() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PrepareShutdown)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PrepareShutdown)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PrepareShutdown)
    }

    // nn::Result ListApplyDeltaTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::ApplyDeltaTaskId>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplyDeltaTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::ApplyDeltaTaskId>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplyDeltaTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplyDeltaTask)
    }

    // nn::Result ClearNotEnoughSpaceStateOfApplyDeltaTask(const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearNotEnoughSpaceStateOfApplyDeltaTask, (const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearNotEnoughSpaceStateOfApplyDeltaTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearNotEnoughSpaceStateOfApplyDeltaTask)
    }

    // nn::Result CreateApplyDeltaTaskFromDownloadTask(nn::sf::Out<nn::nim::ApplyDeltaTaskId> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateApplyDeltaTaskFromDownloadTask, (::nn::sf::Out<::nn::nim::ApplyDeltaTaskId> outValue, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateApplyDeltaTaskFromDownloadTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateApplyDeltaTaskFromDownloadTask)
    }

    // nn::Result GetBackgroundApplyDeltaStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundApplyDeltaStressTaskInfo, (::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBackgroundApplyDeltaStressTaskInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBackgroundApplyDeltaStressTaskInfo)
    }

    // nn::Result GetApplyDeltaTaskRequiredStorage(nn::sf::Out<nn::ncm::StorageId> outValue, const nn::nim::ApplyDeltaTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplyDeltaTaskRequiredStorage, (::nn::sf::Out<::nn::ncm::StorageId> outValue, const ::nn::nim::ApplyDeltaTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplyDeltaTaskRequiredStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplyDeltaTaskRequiredStorage)
    }

    // nn::Result CalculateNetworkInstallTaskContentsSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::NetworkInstallTaskId& id, const nn::ncm::ContentMetaKey& key, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateNetworkInstallTaskContentsSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::NetworkInstallTaskId& id, const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CalculateNetworkInstallTaskContentsSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CalculateNetworkInstallTaskContentsSize)
    }

    // nn::Result PrepareShutdownForSystemUpdate() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PrepareShutdownForSystemUpdate)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PrepareShutdownForSystemUpdate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PrepareShutdownForSystemUpdate)
    }

    // nn::Result FindMaxRequiredApplicationVersionOfTask(nn::sf::Out<std::uint32_t> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindMaxRequiredApplicationVersionOfTask, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FindMaxRequiredApplicationVersionOfTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FindMaxRequiredApplicationVersionOfTask)
    }

    // nn::Result CommitNetworkInstallTaskPartially(const nn::sf::InArray<nn::ncm::StorageContentMetaKey>& list, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitNetworkInstallTaskPartially, (const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>& list, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CommitNetworkInstallTaskPartially)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(list)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CommitNetworkInstallTaskPartially)
    }

    // nn::Result ListNetworkInstallTaskCommittedContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskCommittedContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListNetworkInstallTaskCommittedContentMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListNetworkInstallTaskCommittedContentMeta)
    }

    // nn::Result ListNetworkInstallTaskNotCommittedContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskNotCommittedContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListNetworkInstallTaskNotCommittedContentMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListNetworkInstallTaskNotCommittedContentMeta)
    }

    // nn::Result FindMaxRequiredSystemVersionOfTask(nn::sf::Out<std::uint32_t> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindMaxRequiredSystemVersionOfTask, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FindMaxRequiredSystemVersionOfTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FindMaxRequiredSystemVersionOfTask)
    }

    // nn::Result GetNetworkInstallTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNetworkInstallTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNetworkInstallTaskErrorContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNetworkInstallTaskErrorContext)
    }

    // nn::Result CreateLocalCommunicationReceiveApplicationTask(nn::sf::Out<nn::nim::LocalCommunicationReceiveApplicationTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, nn::ncm::ApplicationId appId, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storage, nn::Bit32 config) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateLocalCommunicationReceiveApplicationTask, (::nn::sf::Out<::nn::nim::LocalCommunicationReceiveApplicationTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, ::nn::ncm::ApplicationId appId, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storage, ::nn::Bit32 config))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateLocalCommunicationReceiveApplicationTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ipv4)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(port)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keyList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(config)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateLocalCommunicationReceiveApplicationTask)
    }

    // nn::Result DestroyLocalCommunicationReceiveApplicationTask(const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationReceiveApplicationTask, (const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyLocalCommunicationReceiveApplicationTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyLocalCommunicationReceiveApplicationTask)
    }

    // nn::Result ListLocalCommunicationReceiveApplicationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListLocalCommunicationReceiveApplicationTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListLocalCommunicationReceiveApplicationTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListLocalCommunicationReceiveApplicationTask)
    }

    // nn::Result RequestLocalCommunicationReceiveApplicationTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLocalCommunicationReceiveApplicationTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestLocalCommunicationReceiveApplicationTaskRun)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestLocalCommunicationReceiveApplicationTaskRun)
    }

    // nn::Result GetLocalCommunicationReceiveApplicationTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationReceiveApplicationTaskInfo> outValue, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveApplicationTaskInfo, (::nn::sf::Out<::nn::nim::LocalCommunicationReceiveApplicationTaskInfo> outValue, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLocalCommunicationReceiveApplicationTaskInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLocalCommunicationReceiveApplicationTaskInfo)
    }

    // nn::Result CommitLocalCommunicationReceiveApplicationTask(const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitLocalCommunicationReceiveApplicationTask, (const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CommitLocalCommunicationReceiveApplicationTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CommitLocalCommunicationReceiveApplicationTask)
    }

    // nn::Result ListLocalCommunicationReceiveApplicationTaskContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, std::int32_t offset, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListLocalCommunicationReceiveApplicationTaskContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListLocalCommunicationReceiveApplicationTaskContentMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListLocalCommunicationReceiveApplicationTaskContentMeta)
    }

    // nn::Result CreateLocalCommunicationSendApplicationTask(nn::sf::Out<nn::nim::LocalCommunicationSendApplicationTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, const nn::sf::InArray<nn::ncm::StorageContentMetaKey>& keyList, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateLocalCommunicationSendApplicationTask, (::nn::sf::Out<::nn::nim::LocalCommunicationSendApplicationTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>& keyList, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateLocalCommunicationSendApplicationTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ipv4)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(port)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keyList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateLocalCommunicationSendApplicationTask)
    }

    // nn::Result RequestLocalCommunicationSendApplicationTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLocalCommunicationSendApplicationTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationSendApplicationTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestLocalCommunicationSendApplicationTaskRun)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestLocalCommunicationSendApplicationTaskRun)
    }

    // nn::Result GetLocalCommunicationReceiveApplicationTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveApplicationTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLocalCommunicationReceiveApplicationTaskErrorContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLocalCommunicationReceiveApplicationTaskErrorContext)
    }

    // nn::Result GetLocalCommunicationSendApplicationTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationSendApplicationTaskInfo> outValue, const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendApplicationTaskInfo, (::nn::sf::Out<::nn::nim::LocalCommunicationSendApplicationTaskInfo> outValue, const ::nn::nim::LocalCommunicationSendApplicationTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLocalCommunicationSendApplicationTaskInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLocalCommunicationSendApplicationTaskInfo)
    }

    // nn::Result DestroyLocalCommunicationSendApplicationTask(const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationSendApplicationTask, (const ::nn::nim::LocalCommunicationSendApplicationTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyLocalCommunicationSendApplicationTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyLocalCommunicationSendApplicationTask)
    }

    // nn::Result GetLocalCommunicationSendApplicationTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationSendApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendApplicationTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationSendApplicationTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLocalCommunicationSendApplicationTaskErrorContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLocalCommunicationSendApplicationTaskErrorContext)
    }

    // nn::Result CalculateLocalCommunicationReceiveApplicationTaskRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::LocalCommunicationReceiveApplicationTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateLocalCommunicationReceiveApplicationTaskRequiredSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::LocalCommunicationReceiveApplicationTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CalculateLocalCommunicationReceiveApplicationTaskRequiredSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CalculateLocalCommunicationReceiveApplicationTaskRequiredSize)
    }

    // nn::Result ListApplicationLocalCommunicationReceiveApplicationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationLocalCommunicationReceiveApplicationTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveApplicationTaskId>& outList, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationLocalCommunicationReceiveApplicationTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationLocalCommunicationReceiveApplicationTask)
    }

    // nn::Result ListApplicationLocalCommunicationSendApplicationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationSendApplicationTaskId>& outList, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationLocalCommunicationSendApplicationTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationSendApplicationTaskId>& outList, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationLocalCommunicationSendApplicationTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationLocalCommunicationSendApplicationTask)
    }

    // nn::Result CreateLocalCommunicationReceiveSystemUpdateTask(nn::sf::Out<nn::nim::LocalCommunicationReceiveSystemUpdateTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, const nn::ncm::ContentMetaKey& key, nn::Bit32 config) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateLocalCommunicationReceiveSystemUpdateTask, (::nn::sf::Out<::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ncm::ContentMetaKey& key, ::nn::Bit32 config))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateLocalCommunicationReceiveSystemUpdateTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ipv4)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(port)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(config)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateLocalCommunicationReceiveSystemUpdateTask)
    }

    // nn::Result DestroyLocalCommunicationReceiveSystemUpdateTask(const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationReceiveSystemUpdateTask, (const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyLocalCommunicationReceiveSystemUpdateTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyLocalCommunicationReceiveSystemUpdateTask)
    }

    // nn::Result ListLocalCommunicationReceiveSystemUpdateTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationReceiveSystemUpdateTaskId>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListLocalCommunicationReceiveSystemUpdateTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListLocalCommunicationReceiveSystemUpdateTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListLocalCommunicationReceiveSystemUpdateTask)
    }

    // nn::Result RequestLocalCommunicationReceiveSystemUpdateTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLocalCommunicationReceiveSystemUpdateTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestLocalCommunicationReceiveSystemUpdateTaskRun)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestLocalCommunicationReceiveSystemUpdateTaskRun)
    }

    // nn::Result GetLocalCommunicationReceiveSystemUpdateTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationReceiveSystemUpdateTaskInfo> outValue, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveSystemUpdateTaskInfo, (::nn::sf::Out<::nn::nim::LocalCommunicationReceiveSystemUpdateTaskInfo> outValue, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLocalCommunicationReceiveSystemUpdateTaskInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLocalCommunicationReceiveSystemUpdateTaskInfo)
    }

    // nn::Result CommitLocalCommunicationReceiveSystemUpdateTask(const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitLocalCommunicationReceiveSystemUpdateTask, (const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CommitLocalCommunicationReceiveSystemUpdateTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CommitLocalCommunicationReceiveSystemUpdateTask)
    }

    // nn::Result GetLocalCommunicationReceiveSystemUpdateTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationReceiveSystemUpdateTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLocalCommunicationReceiveSystemUpdateTaskErrorContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLocalCommunicationReceiveSystemUpdateTaskErrorContext)
    }

    // nn::Result CreateLocalCommunicationSendSystemUpdateTask(nn::sf::Out<nn::nim::LocalCommunicationSendSystemUpdateTaskId> outValue, std::uint32_t ipv4, std::uint16_t port, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateLocalCommunicationSendSystemUpdateTask, (::nn::sf::Out<::nn::nim::LocalCommunicationSendSystemUpdateTaskId> outValue, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateLocalCommunicationSendSystemUpdateTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ipv4)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(port)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateLocalCommunicationSendSystemUpdateTask)
    }

    // nn::Result RequestLocalCommunicationSendSystemUpdateTaskRun(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLocalCommunicationSendSystemUpdateTaskRun, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestLocalCommunicationSendSystemUpdateTaskRun)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestLocalCommunicationSendSystemUpdateTaskRun)
    }

    // nn::Result GetLocalCommunicationSendSystemUpdateTaskInfo(nn::sf::Out<nn::nim::LocalCommunicationSendSystemUpdateTaskInfo> outValue, const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendSystemUpdateTaskInfo, (::nn::sf::Out<::nn::nim::LocalCommunicationSendSystemUpdateTaskInfo> outValue, const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLocalCommunicationSendSystemUpdateTaskInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLocalCommunicationSendSystemUpdateTaskInfo)
    }

    // nn::Result DestroyLocalCommunicationSendSystemUpdateTask(const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyLocalCommunicationSendSystemUpdateTask, (const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyLocalCommunicationSendSystemUpdateTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyLocalCommunicationSendSystemUpdateTask)
    }

    // nn::Result GetLocalCommunicationSendSystemUpdateTaskErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, const nn::nim::LocalCommunicationSendSystemUpdateTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLocalCommunicationSendSystemUpdateTaskErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, const ::nn::nim::LocalCommunicationSendSystemUpdateTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLocalCommunicationSendSystemUpdateTaskErrorContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLocalCommunicationSendSystemUpdateTaskErrorContext)
    }

    // nn::Result ListLocalCommunicationSendSystemUpdateTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::nim::LocalCommunicationSendSystemUpdateTaskId>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListLocalCommunicationSendSystemUpdateTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::nim::LocalCommunicationSendSystemUpdateTaskId>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListLocalCommunicationSendSystemUpdateTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListLocalCommunicationSendSystemUpdateTask)
    }

    // nn::Result GetReceivedSystemDataPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::SystemDataId dataId, const nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& taskId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivedSystemDataPath, (::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::SystemDataId dataId, const ::nn::nim::LocalCommunicationReceiveSystemUpdateTaskId& taskId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReceivedSystemDataPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(taskId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReceivedSystemDataPath)
    }

    // nn::Result CalculateApplyDeltaTaskOccupiedSize(nn::sf::Out<std::int64_t> outValue, const nn::nim::ApplyDeltaTaskId& id, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplyDeltaTaskOccupiedSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::nim::ApplyDeltaTaskId& id, ::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CalculateApplyDeltaTaskOccupiedSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CalculateApplyDeltaTaskOccupiedSize)
    }

    // void ReloadErrorSimulation() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(ReloadErrorSimulation)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReloadErrorSimulation)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReloadErrorSimulation)
    }

    // nn::Result ListNetworkInstallTaskContentMetaFromInstallMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskContentMetaFromInstallMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListNetworkInstallTaskContentMetaFromInstallMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListNetworkInstallTaskContentMetaFromInstallMeta)
    }

    // nn::Result ListNetworkInstallTaskOccupiedSize(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::InstallTaskOccupiedSize>& outList, std::int32_t offset, const nn::nim::NetworkInstallTaskId& id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNetworkInstallTaskOccupiedSize, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::InstallTaskOccupiedSize>& outList, ::std::int32_t offset, const ::nn::nim::NetworkInstallTaskId& id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListNetworkInstallTaskOccupiedSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListNetworkInstallTaskOccupiedSize)
    }

    // nn::Result RequestQueryAvailableELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::RightsId>& rightsIds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestQueryAvailableELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestQueryAvailableELicenses)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestQueryAvailableELicenses)
    }

    // nn::Result RequestAssignELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::RightsId>& rightsIds, nn::nim::ELicenseType licenseType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestAssignELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIds, ::nn::nim::ELicenseType licenseType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestAssignELicenses)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rightsIds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(licenseType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestAssignELicenses)
    }

    // nn::Result RequestExtendELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestExtendELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestExtendELicenses)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(elicenseIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestExtendELicenses)
    }

    // nn::Result RequestSyncELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, nn::account::NintendoAccountId naId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, ::nn::account::NintendoAccountId naId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestSyncELicenses)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(naId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestSyncELicenses)
    }

    // nn::Result RequestDownloadETickets(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, const nn::account::Uid& uid, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadETickets, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestDownloadETickets)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(elicenseIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestDownloadETickets)
    }

    // nn::Result RequestQueryRevokeReason(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncValue>> outValue, nn::account::NintendoAccountId naId, const nn::es::ELicenseId& eLicenseId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestQueryRevokeReason, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>> outValue, ::nn::account::NintendoAccountId naId, const ::nn::es::ELicenseId& eLicenseId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestQueryRevokeReason)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(naId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eLicenseId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestQueryRevokeReason)
    }

    // nn::Result RequestReportActiveELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, nn::account::NintendoAccountId naId, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestReportActiveELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, ::nn::account::NintendoAccountId naId, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestReportActiveELicenses)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(naId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(elicenseIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestReportActiveELicenses)
    }

    // nn::Result RequestReportActiveELicensesPassively(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outValue, nn::account::NintendoAccountId naId, const nn::sf::InArray<nn::es::ELicenseId>& elicenseIds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestReportActiveELicensesPassively, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outValue, ::nn::account::NintendoAccountId naId, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestReportActiveELicensesPassively)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(naId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(elicenseIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestReportActiveELicensesPassively)
    }

    // nn::Result RequestRegisterDynamicRightsNotificationToken(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncResult>> outAsync, const nn::npns::NotificationToken& notificationToken) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestRegisterDynamicRightsNotificationToken, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>> outAsync, const ::nn::npns::NotificationToken& notificationToken))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestRegisterDynamicRightsNotificationToken)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(notificationToken)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestRegisterDynamicRightsNotificationToken)
    }

    // nn::Result RequestAssignAllDeviceLinkedELicenses(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IAsyncData>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestAssignAllDeviceLinkedELicenses, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestAssignAllDeviceLinkedELicenses)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestAssignAllDeviceLinkedELicenses)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nim::detail::INetworkInstallManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nim::detail::INetworkInstallManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSystemUpdateTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(config)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroySystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroySystemUpdateTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListSystemUpdateTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestSystemUpdateTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestSystemUpdateTaskRun)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemUpdateTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemUpdateTaskInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CommitSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CommitSystemUpdateTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateNetworkInstallTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(keyList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateNetworkInstallTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(keyList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(config)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyNetworkInstallTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyNetworkInstallTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListNetworkInstallTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListNetworkInstallTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestNetworkInstallTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestNetworkInstallTaskRun)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNetworkInstallTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNetworkInstallTaskInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CommitNetworkInstallTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CommitNetworkInstallTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestLatestSystemUpdateMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestLatestSystemUpdateMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationNetworkInstallTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationNetworkInstallTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListNetworkInstallTaskContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListNetworkInstallTaskContentMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestLatestVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestLatestVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetNetworkInstallTaskAttribute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetNetworkInstallTaskAttribute)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(idAttribute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddNetworkInstallTaskContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(list)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddNetworkInstallTaskContentMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(list),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDownloadedSystemDataPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDownloadedSystemDataPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dataId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(taskId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CalculateNetworkInstallTaskRequiredSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CalculateNetworkInstallTaskRequiredSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsExFatDriverIncluded)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsExFatDriverIncluded)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBackgroundDownloadStressTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBackgroundDownloadStressTaskInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestDeviceAuthenticationToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestDeviceAuthenticationToken)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestGameCardRegistrationStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(appIdList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(token)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(cert)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestGameCardRegistrationStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(appIdList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(token),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(cert)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestRegisterGameCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(appIdList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(token)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(cert)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestRegisterGameCard)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(appIdList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(token),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(cert),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(status)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestRegisterNotificationToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestRegisterNotificationToken)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(notificationToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestDownloadTaskList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestDownloadTaskList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eTag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestApplicationControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestApplicationControl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestLatestApplicationControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestLatestApplicationControl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestVersionList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eTag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(keyList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateApplyDeltaTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(keyList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyApplyDeltaTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationApplyDeltaTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestApplyDeltaTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestApplyDeltaTaskRun)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplyDeltaTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplyDeltaTaskInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplyDeltaTaskContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplyDeltaTaskContentMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CommitApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CommitApplyDeltaTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CalculateApplyDeltaTaskRequiredSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CalculateApplyDeltaTaskRequiredSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PrepareShutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PrepareShutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplyDeltaTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearNotEnoughSpaceStateOfApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearNotEnoughSpaceStateOfApplyDeltaTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateApplyDeltaTaskFromDownloadTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateApplyDeltaTaskFromDownloadTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBackgroundApplyDeltaStressTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBackgroundApplyDeltaStressTaskInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplyDeltaTaskRequiredStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplyDeltaTaskRequiredStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CalculateNetworkInstallTaskContentsSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CalculateNetworkInstallTaskContentsSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PrepareShutdownForSystemUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PrepareShutdownForSystemUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FindMaxRequiredApplicationVersionOfTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FindMaxRequiredApplicationVersionOfTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CommitNetworkInstallTaskPartially)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(list)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CommitNetworkInstallTaskPartially)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(list),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListNetworkInstallTaskCommittedContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListNetworkInstallTaskCommittedContentMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListNetworkInstallTaskNotCommittedContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListNetworkInstallTaskNotCommittedContentMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FindMaxRequiredSystemVersionOfTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FindMaxRequiredSystemVersionOfTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNetworkInstallTaskErrorContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNetworkInstallTaskErrorContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateLocalCommunicationReceiveApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(keyList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateLocalCommunicationReceiveApplicationTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ipv4),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(port),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(keyList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(config)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyLocalCommunicationReceiveApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyLocalCommunicationReceiveApplicationTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListLocalCommunicationReceiveApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListLocalCommunicationReceiveApplicationTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestLocalCommunicationReceiveApplicationTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestLocalCommunicationReceiveApplicationTaskRun)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLocalCommunicationReceiveApplicationTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLocalCommunicationReceiveApplicationTaskInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CommitLocalCommunicationReceiveApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CommitLocalCommunicationReceiveApplicationTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListLocalCommunicationReceiveApplicationTaskContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListLocalCommunicationReceiveApplicationTaskContentMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateLocalCommunicationSendApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(keyList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateLocalCommunicationSendApplicationTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ipv4),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(port),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(keyList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestLocalCommunicationSendApplicationTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestLocalCommunicationSendApplicationTaskRun)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLocalCommunicationReceiveApplicationTaskErrorContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLocalCommunicationReceiveApplicationTaskErrorContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLocalCommunicationSendApplicationTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLocalCommunicationSendApplicationTaskInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyLocalCommunicationSendApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyLocalCommunicationSendApplicationTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLocalCommunicationSendApplicationTaskErrorContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLocalCommunicationSendApplicationTaskErrorContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CalculateLocalCommunicationReceiveApplicationTaskRequiredSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CalculateLocalCommunicationReceiveApplicationTaskRequiredSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationLocalCommunicationReceiveApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationLocalCommunicationReceiveApplicationTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationLocalCommunicationSendApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationLocalCommunicationSendApplicationTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateLocalCommunicationReceiveSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateLocalCommunicationReceiveSystemUpdateTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ipv4),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(port),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(config)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyLocalCommunicationReceiveSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyLocalCommunicationReceiveSystemUpdateTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListLocalCommunicationReceiveSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListLocalCommunicationReceiveSystemUpdateTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestLocalCommunicationReceiveSystemUpdateTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestLocalCommunicationReceiveSystemUpdateTaskRun)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLocalCommunicationReceiveSystemUpdateTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLocalCommunicationReceiveSystemUpdateTaskInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CommitLocalCommunicationReceiveSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CommitLocalCommunicationReceiveSystemUpdateTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLocalCommunicationReceiveSystemUpdateTaskErrorContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLocalCommunicationReceiveSystemUpdateTaskErrorContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateLocalCommunicationSendSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateLocalCommunicationSendSystemUpdateTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ipv4),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(port),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestLocalCommunicationSendSystemUpdateTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestLocalCommunicationSendSystemUpdateTaskRun)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLocalCommunicationSendSystemUpdateTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLocalCommunicationSendSystemUpdateTaskInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyLocalCommunicationSendSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyLocalCommunicationSendSystemUpdateTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLocalCommunicationSendSystemUpdateTaskErrorContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLocalCommunicationSendSystemUpdateTaskErrorContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListLocalCommunicationSendSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListLocalCommunicationSendSystemUpdateTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReceivedSystemDataPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReceivedSystemDataPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dataId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(taskId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CalculateApplyDeltaTaskOccupiedSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CalculateApplyDeltaTaskOccupiedSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReloadErrorSimulation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReloadErrorSimulation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListNetworkInstallTaskContentMetaFromInstallMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListNetworkInstallTaskContentMetaFromInstallMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListNetworkInstallTaskOccupiedSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListNetworkInstallTaskOccupiedSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestQueryAvailableELicenses)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(rightsIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestQueryAvailableELicenses)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(rightsIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestAssignELicenses)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(rightsIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestAssignELicenses)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(rightsIds),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(licenseType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestExtendELicenses)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(elicenseIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestExtendELicenses)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(elicenseIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestSyncELicenses)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestSyncELicenses)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(naId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestDownloadETickets)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(elicenseIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestDownloadETickets)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(elicenseIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestQueryRevokeReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncValue>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestQueryRevokeReason)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(naId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eLicenseId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestReportActiveELicenses)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(elicenseIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestReportActiveELicenses)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(naId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(elicenseIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestReportActiveELicensesPassively)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(elicenseIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestReportActiveELicensesPassively)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(naId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(elicenseIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestRegisterDynamicRightsNotificationToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestRegisterDynamicRightsNotificationToken)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(notificationToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestAssignAllDeviceLinkedELicenses)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IAsyncData>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestAssignAllDeviceLinkedELicenses)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroySystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestSystemUpdateTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemUpdateTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CommitSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateNetworkInstallTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyNetworkInstallTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListNetworkInstallTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestNetworkInstallTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNetworkInstallTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CommitNetworkInstallTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestLatestSystemUpdateMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationNetworkInstallTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListNetworkInstallTaskContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestLatestVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetNetworkInstallTaskAttribute)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddNetworkInstallTaskContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDownloadedSystemDataPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CalculateNetworkInstallTaskRequiredSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsExFatDriverIncluded)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBackgroundDownloadStressTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestDeviceAuthenticationToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestGameCardRegistrationStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestRegisterGameCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestRegisterNotificationToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestDownloadTaskList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestApplicationControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestLatestApplicationControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestApplyDeltaTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplyDeltaTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplyDeltaTaskContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CommitApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CalculateApplyDeltaTaskRequiredSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PrepareShutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearNotEnoughSpaceStateOfApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateApplyDeltaTaskFromDownloadTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBackgroundApplyDeltaStressTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplyDeltaTaskRequiredStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CalculateNetworkInstallTaskContentsSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PrepareShutdownForSystemUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FindMaxRequiredApplicationVersionOfTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CommitNetworkInstallTaskPartially)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListNetworkInstallTaskCommittedContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListNetworkInstallTaskNotCommittedContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FindMaxRequiredSystemVersionOfTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNetworkInstallTaskErrorContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateLocalCommunicationReceiveApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyLocalCommunicationReceiveApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListLocalCommunicationReceiveApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestLocalCommunicationReceiveApplicationTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLocalCommunicationReceiveApplicationTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CommitLocalCommunicationReceiveApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListLocalCommunicationReceiveApplicationTaskContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateLocalCommunicationSendApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestLocalCommunicationSendApplicationTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLocalCommunicationReceiveApplicationTaskErrorContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLocalCommunicationSendApplicationTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyLocalCommunicationSendApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLocalCommunicationSendApplicationTaskErrorContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CalculateLocalCommunicationReceiveApplicationTaskRequiredSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationLocalCommunicationReceiveApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationLocalCommunicationSendApplicationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateLocalCommunicationReceiveSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyLocalCommunicationReceiveSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListLocalCommunicationReceiveSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestLocalCommunicationReceiveSystemUpdateTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLocalCommunicationReceiveSystemUpdateTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CommitLocalCommunicationReceiveSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLocalCommunicationReceiveSystemUpdateTaskErrorContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateLocalCommunicationSendSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestLocalCommunicationSendSystemUpdateTaskRun)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLocalCommunicationSendSystemUpdateTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyLocalCommunicationSendSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLocalCommunicationSendSystemUpdateTaskErrorContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListLocalCommunicationSendSystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReceivedSystemDataPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CalculateApplyDeltaTaskOccupiedSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReloadErrorSimulation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListNetworkInstallTaskContentMetaFromInstallMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListNetworkInstallTaskOccupiedSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestQueryAvailableELicenses)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestAssignELicenses)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestExtendELicenses)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestSyncELicenses)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestDownloadETickets)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestQueryRevokeReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestReportActiveELicenses)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestReportActiveELicensesPassively)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestRegisterDynamicRightsNotificationToken)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestAssignAllDeviceLinkedELicenses)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nim::detail::INetworkInstallManager))
