﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>
#include <nn/nifm/nifm_TypesNetworkProfile.h>
#include <nn/nifm/nifm_TypesAccessPoint.h>
#include <nn/nifm/nifm_TypesRequestPrivate.h>

#include <nn/util/util_BitFlagSet.h>
#include <nnc/nn_Result.h>

namespace nn
{
namespace nifm
{

/**
 * @brief ネットワークテレメトリ情報の各項目の有効または無効を表すフラグです。
 */
struct TelemetryFlag
{
    // 名称は ErrorReport の項目名に準拠
    using ConnectionStatusInfo            = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<0> ; // <! ネットワーク接続状態
    using NetworkInfo                     = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<1> ; // <! 接続設定情報
    using NetworkInfoIpAddressSetting     = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<2> ; // <! 接続設定情報（IP アドレス）
    using NetworkInfoDnsSetting           = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<3> ; // <! 接続設定情報（DNS 設定）
    using LimitHighCapacityInfo           = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<4> ; // <! 大容量通信許可設定
    using AccessPointInfo                 = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<5> ; // <! AP 情報
    using WirelessAPMacAddressInfo        = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<6> ; // <! AP Mac アドレス
    using RadioStrengthInfo               = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<7> ; // <! 電波強度情報
    using StealthNetworkInfo              = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<8> ; // <! ステルス AP に接続試行するか否かの設定情報
    using NXMacAddressInfo                = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<9> ; // <! 本体（無線）の Mac アドレス
    using LANAdapterMacAddressInfo        = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<10>; // <! Ethernet アダプタの Mac アドレス
    using NintendoZoneConnectedInfo       = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<11>; // <! SSID リスト経由の接続か否かの情報
    using NintendoZoneSSIDListVersionInfo = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<12>; // <! SSID リストバージョン
    using ConnectionTestInfo              = nn::util::BitFlagSet<32, TelemetryFlag>::Flag<13>; // <! 接続テスト情報
};

using TelemetryFlagSet = nn::util::BitFlagSet<32, TelemetryFlag>;

/**
* @brief ネットワークテレメトリ情報を表します。
*/
struct TelemetryInfo
{
    TelemetryFlagSet flagSet;               //<! 各項目に対応したフラグ

    nnResult result;                        //<! 接続試行時の result

    NetworkProfileData networkProfileData;  //<! 接続設定
    AccessPointData accessPointData;        //<! AP 情報
    DnsSetting dnsSetting;                  //<! DNS 設定
    IpAddressSetting ipAddressSetting;      //<! IP アドレス情報
    MacAddress ethernetMacAddress;          //<! Ethernet アダプタ Mac アドレス
    MacAddress wirelessMacAddress;          //<! 本体（無線）Mac アドレス
    SsidListVersion ssidListVersion;        //<! SSID リストバージョン
    AdditionalInfo additionalInfo;
};

}
}
