﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>


namespace nn
{
namespace nifm
{

    /**
     * @brief 利用要求のハンドルです。
     */
    struct RequestHandle
    {
        void* _value;
    };

    /**
     * @brief 利用要求の状態を表します。
     */
    enum RequestState
    {
        RequestState_Invalid,   //<! 要求は不正な状態です

        RequestState_Free,      //<! 要求は提出されていません
        RequestState_OnHold,    //<! 要求は検証中です
        RequestState_Accepted,  //<! 要求は受理されています
        RequestState_Blocking,  //<! 要求は取り下げられるべきです

        RequestState_Count
    };


    static const uint8_t UserRequestPriorityTop = 0;      //<! 利用要求優先度の最高値
    static const uint8_t UserRequestPriorityBottom = 31;  //<! 利用要求優先度の最低値
}
}

