﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>

namespace nn
{
namespace nifm
{

    /**
     * @brief ネットワークの種類を表します。
     */
    enum NetworkType
    {
        NetworkType_None,               //<! ネットワーク接続なし
        NetworkType_Internet,           //<! インターネット通信
        NetworkType_Local,              //<! ローカル通信
        NetworkType_NeighborDetection,  //<! ND(TBD)通信

        NetworkType_Count,

        NetworkType_Infrastructure = NetworkType_Internet
    };

}
}

