﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>

namespace nn
{
namespace nifm
{
    //! @name 無線接続情報取得 API
    //! @{

    /**
     * @brief 接続に利用されているアクセスポイントのチャンネルを取得します。
     *
     * @param[out] pOutChannel 取得されるアクセスポイントのチャンネルを格納するバッファへのポインタ
     *
     *
     * @retresult
     *   @handleresult{
     *     nn::ResultSuccess, 処理に成功しました。
     *   }
     * @endretresult
     *
     * @pre
     *   - ライブラリが初期化済み
     *   - pOutChannel != nullptr
     *
     * @details
     *  無線でインターネット接続を行う要求が受理されている場合に成功します。
     *  それ以外の場合は失敗し、その際に得られる値は不定です。
     */
    nn::Result GetCurrentAccessPointChannel(uint16_t* pOutChannel) NN_NOEXCEPT;

    //! @}
}
}
