﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>


namespace nn
{
namespace nifm
{
    //! @name 有線通信制御 API
    //! @{

    /**
     * @brief   有線通信の有効・無効を制御します。
     *
     * @param[in]   isEnabled    有線通信の有効・無効を指定します。
     *
     * @pre
     *   - ライブラリが初期化済み
     *
     * @details
     *  設定した値は @ref nn::nifm::IsEthernetCommunicationEnabled() の結果に即時反映されますが、実際に有線通信が停止・再開するのは遅延する可能性があります。@n
     *
     *  有線通信の有効・無効はグローバル状態であり、設定は他者によって書き換えられる可能性があります。@n
     *
     *  設定値は永続化されず、システムの再起動で true に戻ります。
     */
    void SetEthernetCommunicationEnabled(bool isEnabled) NN_NOEXCEPT;

    /**
    * @brief    有線通信の有効・無効を取得します。
    *
    * @return   有線通信が有効であれば true を、無効であれば false を返します。
    *
    * @pre
    *   - ライブラリが初期化済み
    *
    * @details
    *  @ref nn::nifm::SetEthernetCommunicationEnabled() で設定した値はこの関数の結果に即時反映されますが、実際に有線通信が停止・再開するのは遅延する可能性があります。@n
    *
    *  有線通信の有効・無効はグローバル状態であり、設定は他者によって書き換えられる可能性があります。
    */
    bool IsEthernetCommunicationEnabled() NN_NOEXCEPT;

    //! @}

}
}
