﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/nifm_TypesWirelessSetting.h>
#include <nn/nifm/nifm_TypesNetworkProfile.h>
#include <nn/nifm/nifm_TypesAccessPoint.h>
#include <nn/nifm/nifm_TypesAccessPointExt.h>
#include <nn/nifm/nifm_Result.h>

#include <nn/nifm/detail/core/accessPoint/nifm_WirelessAccessPoint.h>

#include <nn/wlan/wlan_Types.h>
#include <nn/wlan/wlan_Result.h>
#include <nn/wlan/wlan_BssDescriptionReader.h>
#include <nn/wlan/wlan_ScanResultReader.h>

namespace nn
{
namespace nifm
{
namespace detail
{

nn::Result ConvertConnectionStatusToResult(const nn::wlan::ConnectionStatus& connectionStatus) NN_NOEXCEPT;

nn::wlan::SecurityMode ConvertNifmAuthEncryptionToWpaCipherSuiteType(nn::nifm::Authentication auth, nn::nifm::Encryption enc, int wepKeyLength) NN_NOEXCEPT;

nn::nifm::Encryption ConvertWlanCipherSuiteTypeToEncryption(nn::wlan::WpaCipherSuiteType cipher) NN_NOEXCEPT;

int GetWpaCipherSuiteTypePriority( nn::wlan::WpaCipherSuiteType keyType ) NN_NOEXCEPT;

void ConvertToAsciiCodeString( char* outBuffer, int outBufferSize, char* inBuffer, int inBufferSize ) NN_NOEXCEPT;

template<typename T>
nn::wlan::WpaCipherSuiteType GetBestWpaCipherSuiteType(const nn::wlan::WpaInfoElementReader<T>* ie) NN_NOEXCEPT
{
    nn::wlan::WpaCipherSuiteType groupKeyType = ie->GetGroupCipherSuite();

    uint16_t count = ie->GetPairwiseCipherSuiteCount();
    nn::wlan::WpaCipherSuiteType keyType = nn::wlan::WPA_CIPHER_NONE;
    for( int i = 0; i < count; ++i )
    {
        nn::wlan::WpaCipherSuiteType pairwiseKeyType = ie->GetPairwiseCipherSuite(i);
        switch (pairwiseKeyType)
        {
        case nn::wlan::WPA_CIPHER_USE_GROUPKEY:
            keyType =  GetWpaCipherSuiteTypePriority(groupKeyType) < GetWpaCipherSuiteTypePriority(keyType) ? groupKeyType : keyType;
            break;
        case nn::wlan::WPA_CIPHER_TKIP:
        case nn::wlan::WPA_CIPHER_AES_CCMP:
            keyType =  GetWpaCipherSuiteTypePriority(pairwiseKeyType) < GetWpaCipherSuiteTypePriority(keyType) ? pairwiseKeyType : keyType;
            break;
        case nn::wlan::WPA_CIPHER_NONE:
        case nn::wlan::WPA_CIPHER_WEP_40BIT:
        case nn::wlan::WPA_CIPHER_WEP_104BIT:
        case nn::wlan::WPA_CIPHER_AES_OCB:
        default:
            // サポート対象外
            break;
        }
    }

    return keyType;
}

void ReadAccessPointFromBeaconDescriptionReader(WirelessAccessPoint* pWirelessAccessPoint, const nn::wlan::BeaconDescriptionReader& descriptionReader) NN_NOEXCEPT;

void ConvertToWlanSsidFromNifm(nn::wlan::Ssid* pOutSsid, const Ssid& ssid) NN_NOEXCEPT;

void ConvertToWlanBssidFromNifm(nn::wlan::MacAddress* pOutBssid, const MacAddress& bssid) NN_NOEXCEPT;

void ConvertToWlanSecurityFromNifm(nn::wlan::Security* pOutSecurity, const NetworkProfileData& networkProfile, const AccessPointData& accessPointData) NN_NOEXCEPT;

}
}
}
