﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_TypesAccessPoint.h>
#include <nn/nifm/nifm_TypesNetworkProfile.h>
#include <nn/nifm/nifm_TypesInternetConnectionStatus.h>

#include <nn/nifm/detail/service/nifm_INifmService.sfdl.h>

namespace nn
{
namespace nifm
{
namespace detail
{

void ConvertNetworkProfileBasicInfoToSfFromNifm(sf::NetworkProfileBasicInfo* pOutInfo, const NetworkProfileBasicInfo& profile) NN_NOEXCEPT;

void ConvertNetworkProfileBasicInfoToNifmFromSf(NetworkProfileBasicInfo* pOutInfo, const sf::NetworkProfileBasicInfo& profile) NN_NOEXCEPT;

void ConvertNetworkProfileDataToSfFromNifm( sf::NetworkProfileData* pOutProfile, const NetworkProfileData& profile ) NN_NOEXCEPT;

void ConvertNetworkProfileDataToNifmFromSf( NetworkProfileData* pOutProfile, const sf::NetworkProfileData& profile ) NN_NOEXCEPT;

void ConvertAccessPointDataToSfFromNifm( sf::AccessPointData* pOutAccessPointData, const AccessPointData& accessPoint ) NN_NOEXCEPT;

void ConvertAccessPointDataToNifmFromSf( AccessPointData* pOutAccessPointData, const sf::AccessPointData& accessPoint ) NN_NOEXCEPT;

void ConvertNetworkInterfaceInfoToSfFromNifm( sf::NetworkInterfaceInfo* pOutNetworkInterfaceInfo, const NetworkInterfaceInfo& networkInterfaceInfo ) NN_NOEXCEPT;

void ConvertNetworkInterfaceInfoToNifmFromSf( NetworkInterfaceInfo* pOutNetworkInterfaceInfo, const sf::NetworkInterfaceInfo& networkInterfaceInfo ) NN_NOEXCEPT;

void ConvertInternetConnectionStatusToSfFromNifm(sf::InternetConnectionStatus* pOutConnectionStatus, const InternetConnectionStatus& connectionInfo) NN_NOEXCEPT;

void ConvertInternetConnectionStatusToNifmFromSf(InternetConnectionStatus* pOutConnectionStatus, const sf::InternetConnectionStatus& connectionInfo) NN_NOEXCEPT;

// 互換性維持のため

void ConvertAccessPointDataToSfFromNifm(sf::AccessPointDataOld* pOutAccessPointData, const AccessPointData& accessPoint) NN_NOEXCEPT;
void ConvertAccessPointDataToNifmFromSf(AccessPointData* pOutAccessPointData, const sf::AccessPointDataOld& accessPoint) NN_NOEXCEPT;

}
}
}
