﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/nifm/nifm_TypesNetwork.h>
#include <nn/nifm/nifm_TypesNetworkInterface.h>
#include <nn/nifm/nifm_TypesInternetConnectionStatus.h>
#include <nn/nifm/nifm_TypesRequirement.h>

namespace nn
{
namespace wlan
{
class Ssid;
class MacAddress;
struct Security;
}

namespace nifm
{
struct AccessPointData;
struct NetworkProfileData;
struct MacAddress;

namespace detail
{
class RequestManager;
class NetworkProfileManager;
class AccessPointListBase;
class NetworkInterfaceBase;
struct AggregatedRequestType;
struct NetworkResourceInfo;
using TotalNetworkResourceInfo = NetworkResourceInfo;

void Dump(const RequestManager& requestManager) NN_NOEXCEPT;
void Dump(const AccessPointData& accessPoint) NN_NOEXCEPT;
void Dump(const NetworkProfileData& networkProfile) NN_NOEXCEPT;
void Dump(const AggregatedRequestType& aggregatedRequestType) NN_NOEXCEPT;
void Dump(const TotalNetworkResourceInfo& totalNetworkResourceInfo) NN_NOEXCEPT;
void Dump(const NetworkProfileManager& networkProfileManager) NN_NOEXCEPT;
void Dump(const AccessPointListBase& accessPointList) NN_NOEXCEPT;
void Dump(const NetworkInterfaceBase& networkInterface) NN_NOEXCEPT;
void Dump(const MacAddress& macAddress) NN_NOEXCEPT;
void Dump(const NetworkType& networkType, const NetworkInterfaceType& networkInterfaceType, const InternetAvailability& internetAvailability,
    const ConnectionConfirmationOption& op, const ConnectionConfirmationOption& opSub) NN_NOEXCEPT;
void Dump(const nn::wlan::Ssid& ssid, const nn::wlan::MacAddress& macAddress, uint16_t channel, const nn::wlan::Security& security) NN_NOEXCEPT;

}
}
}
