﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/detail/service/nifm_INifmService.sfdl.h>
#include <nn/nifm/detail/service/nifm_ServiceProvider.h>

#if NN_DETAIL_NIFM_CONFIG_SERVER_MODEL == NN_DETAIL_NIFM_CONFIG_SERVER_MODEL_THREAD
#include <nn/os/os_Thread.h>
#endif


namespace nn
{
namespace nifm
{
namespace detail
{

class ServiceProviderClient
{
private:
#if NN_DETAIL_NIFM_CONFIG_SERVER_MODEL == NN_DETAIL_NIFM_CONFIG_SERVER_MODEL_THREAD
    // TODO: コンストラクタに時間がかかりすぎるようなら、オブジェクトの生成もスレッドに移す
    // TODO: その際、 DFC モデルでも、準備完了まで API がブロックするように変更する
    ServiceProvider m_ServiceProvider;

#if NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    nn::os::ThreadType m_ThreadType;
    static const size_t ThreadStackSize = 4 * 1024;     // TODO:Win32 以外の環境では足りないかも
    char m_ThreadStackBuffer[ThreadStackSize + nn::os::ThreadStackAlignment - 1];
    static void ServerManagerThreadFunction(void* pContext) NN_NOEXCEPT;
#endif
#endif

public:
    ServiceProviderClient() NN_NOEXCEPT;
    ~ServiceProviderClient() NN_NOEXCEPT;

    nn::Result GetUserServiceSharedPointer(nn::sf::SharedPointer<detail::IGeneralService>* pGeneralService) NN_NOEXCEPT;
    nn::Result GetAdminServiceSharedPointer(nn::sf::SharedPointer<detail::IGeneralService>* pGeneralService) NN_NOEXCEPT;
    nn::Result GetSystemServiceSharedPointer(nn::sf::SharedPointer<detail::IGeneralService>* pGeneralService) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;
};

}
}
}
