﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/service/nifm_StaticServiceInterface.h>
#include <nn/nifm/detail/util/nifm_Heap.h>

#include <nn/sf/sf_HipcSimpleAllInOneServerManager.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class ServiceProvider;
class PowerStateCoordinator;

static const size_t SessionCountMax = 2 + 16 + 5; // Admin, System, User
static const size_t PortCountMax = 3;

// 1サービスが1サブドメイン，1セッション想定
struct HipcSimpleAllInOneServerManagerOptions
{
    static const size_t PointerTransferBufferSize = 500; // NetworkProfileData:380
    static const int SubDomainCountMax = SessionCountMax;
    static const int ObjectInSubDomainCountMax = 33 + SubDomainCountMax + 7; // 利用要求最大数 + 利用サービス数 + α
};

class HipcServerManager : public nn::sf::HipcSimpleAllInOneServerManager<SessionCountMax, PortCountMax, HipcSimpleAllInOneServerManagerOptions>
{
private:
    SfExpHeapAllocator<16 * 1024> m_SfExpHeapAllocator;

    nn::sf::UnmanagedServiceObject<IStaticService, StaticServiceInterface> m_AdminStaticService;
    nn::sf::UnmanagedServiceObject<IStaticService, StaticServiceInterface> m_SystemStaticService;
    nn::sf::UnmanagedServiceObject<IStaticService, StaticServiceInterface> m_UserStaticService;

    PowerStateCoordinator* m_pPowerStateCoordinator;

public:
    explicit HipcServerManager(ServiceProvider* pServiceProvider) NN_NOEXCEPT;
    ~HipcServerManager() NN_NOEXCEPT;

    void MyLoopAuto() NN_NOEXCEPT;

    // HIPC モデルではサービスオブジェクトへの SharedPointer は IPC 経由で取得する
};

}
}
}
