﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/service/nifm_INifmService.sfdl.h>
#include <nn/nifm/detail/service/nifm_Capability.h>
#include <nn/nifm/nifm_TypesClientManagement.h>


namespace nn
{
namespace sf
{
struct ExpHeapAllocator;
}
namespace nifm
{
namespace detail
{

class ServiceProvider;

class GeneralServiceInterface
{
private:
    ServiceProvider* m_pServiceProvider;
    const Capability& m_Capability;
    nn::sf::ExpHeapAllocator* m_pExpHeapAllocator;

    ClientId m_ClientId;
    const nn::Bit64 m_ProcessId;

public:
    GeneralServiceInterface(ServiceProvider* pServiceProvider, const Capability& capability, nn::sf::ExpHeapAllocator* pExpHeapAllocator, ClientId clientId, nn::Bit64 processId) NN_NOEXCEPT;

    ~GeneralServiceInterface() NN_NOEXCEPT;

    nn::Result GetClientId(nn::sf::Out<ClientId> outClientId) const NN_NOEXCEPT;

    nn::Result CreateScanRequest(nn::sf::Out<nn::sf::SharedPointer<IScanRequest>> outIScanRequest) NN_NOEXCEPT;

    nn::Result GetAllowedChannels(nn::sf::OutArray<int16_t> outChannelArray, nn::sf::Out<int> outCount) const NN_NOEXCEPT;

    nn::Result GetScanData(nn::sf::OutArray<detail::sf::AccessPointData> outAccessPointDataArray, nn::sf::Out<int32_t> outCount ) const NN_NOEXCEPT;

    nn::Result CreateRequest(nn::sf::Out<nn::sf::SharedPointer<IRequest>> outIRequest, int32_t requirementPreset) NN_NOEXCEPT;

    nn::Result GetCurrentNetworkProfile( nn::sf::Out<sf::NetworkProfileData> outNetworkProfileData ) const NN_NOEXCEPT;

    nn::Result EnumerateNetworkInterfaces( nn::sf::OutArray<sf::NetworkInterfaceInfo> outNetworkInterfaceInfoArray, nn::sf::Out<int32_t> outCount, nn::Bit32 filterFlags ) const NN_NOEXCEPT;

    nn::Result EnumerateNetworkProfiles( nn::sf::OutArray<sf::NetworkProfileBasicInfo> outNetworkProfileBasicInfoArray, nn::sf::Out<int32_t> outCount, nn::Bit8 type ) const NN_NOEXCEPT;

    nn::Result GetNetworkProfile( nn::sf::Out<sf::NetworkProfileData> outNetworkProfileData, const nn::util::Uuid& id ) const NN_NOEXCEPT;

    nn::Result SetNetworkProfile( nn::sf::Out<nn::util::Uuid> outId, const sf::NetworkProfileData& networkProfileData ) NN_NOEXCEPT;

    nn::Result RemoveNetworkProfile( const nn::util::Uuid& id ) NN_NOEXCEPT;

    nn::Result GetCurrentIpAddress( nn::sf::Out<IpV4Address> outIpAddress ) NN_NOEXCEPT;

    nn::Result GetCurrentAccessPoint( nn::sf::Out<detail::sf::AccessPointData> outAccessPointData ) NN_NOEXCEPT;

    nn::Result CreateTemporaryNetworkProfile( nn::sf::Out<nn::sf::SharedPointer<INetworkProfile>> outINetworkProfile, nn::sf::Out<nn::util::Uuid> outNetworkProfileId, const sf::NetworkProfileData& networkProfileData ) NN_NOEXCEPT;

    nn::Result GetCurrentIpConfigInfo( nn::sf::Out<IpAddressSetting> outIpAddressSetting, nn::sf::Out<DnsSetting> outDnsSetting) NN_NOEXCEPT;

    nn::Result SetWirelessCommunicationEnabled(bool isEnabled) NN_NOEXCEPT;

    nn::Result SetWirelessCommunicationEnabledForTest(bool isEnabled) NN_NOEXCEPT;

    nn::Result IsWirelessCommunicationEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT;

    nn::Result GetInternetConnectionStatus(nn::sf::Out<sf::InternetConnectionStatus> outConnectionStatus) NN_NOEXCEPT;

    nn::Result SetEthernetCommunicationEnabled(bool isEnabled) NN_NOEXCEPT;

    nn::Result SetEthernetCommunicationEnabledForTest(bool isEnabled) NN_NOEXCEPT;

    nn::Result IsEthernetCommunicationEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT;

    nn::Result IsAnyInternetRequestAccepted(nn::sf::Out<bool> outIsAnyInternetRequestAccepted, ClientId clientId) NN_NOEXCEPT;

    nn::Result IsAnyForegroundRequestAccepted(nn::sf::Out<bool> outIsAnyForegroundRequestAccepted) NN_NOEXCEPT;

    nn::Result PutToSleep() NN_NOEXCEPT;

    nn::Result WakeUp() NN_NOEXCEPT;

    nn::Result Shutdown() NN_NOEXCEPT;

    nn::Result SetExclusiveClient(const ClientId& clientId) NN_NOEXCEPT;

    nn::Result GetSsidListVersion(nn::sf::Out<SsidListVersion> outSsidListVersion) const NN_NOEXCEPT;

    nn::Result GetDefaultIpSetting(nn::sf::Out<IpSettingData> outIpSettingData) const NN_NOEXCEPT;

    nn::Result SetDefaultIpSetting(const IpSettingData& ipSettingData) NN_NOEXCEPT;

    nn::Result GetTelemetorySystemEventReadableHandle(nn::sf::Out<nn::sf::NativeHandle> systemEventReadableHandle) const NN_NOEXCEPT;

    nn::Result GetTelemetryInfo(nn::sf::Out<TelemetryInfo> outTelemetryInfo) const NN_NOEXCEPT;

    nn::Result ConfirmSystemAvailability() const NN_NOEXCEPT;

    nn::Result SetBackgroundRequestEnabled(bool isEnabled) NN_NOEXCEPT;

    // 互換性維持のため
    nn::Result GetScanDataOld(nn::sf::OutArray<detail::sf::AccessPointDataOld> outAccessPointDataArray, nn::sf::Out<int32_t> outCount) const NN_NOEXCEPT;
    nn::Result GetCurrentAccessPointOld(nn::sf::Out<detail::sf::AccessPointDataOld> outAccessPointData) NN_NOEXCEPT;
};

}
}
}
