﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_IntrusiveList.h>
#include <nn/os/os_SdkMutex.h>

namespace nn
{
namespace nifm
{
namespace detail
{

template<typename T>
class ServiceObjectList
{
    NN_DISALLOW_COPY(ServiceObjectList);
    NN_DISALLOW_MOVE(ServiceObjectList);

public:
    using ListType = nn::util::IntrusiveList<T, nn::util::IntrusiveListBaseNodeTraits<T>>;

private:
    ListType m_List;
    nn::os::SdkMutex m_Mutex;

public:
    ServiceObjectList() {}
    ~ServiceObjectList() {}

    ListType* GetPointer() { return &m_List; }
    void Lock() { m_Mutex.lock(); }
    void Unlock() { m_Mutex.unlock(); }
};

}
}
}
