﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      nifm モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#if defined(NN_DETAIL_NIFM_LOG_ENABLED)

#define NN_DETAIL_NIFM_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIFM_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIFM_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIFM_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIFM_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIFM_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Trace, 0, format, args)
#define NN_DETAIL_NIFM_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Trace, 1, format, args)
#define NN_DETAIL_NIFM_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Trace, 2, format, args)
#define NN_DETAIL_NIFM_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Trace, 3, format, args)

#define NN_DETAIL_NIFM_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Info, 0, format, args)
#define NN_DETAIL_NIFM_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Info, 1, format, args)
#define NN_DETAIL_NIFM_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Info, 2, format, args)
#define NN_DETAIL_NIFM_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Info, 3, format, args)

#define NN_DETAIL_NIFM_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Warn, 0, format, args)
#define NN_DETAIL_NIFM_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Warn, 1, format, args)
#define NN_DETAIL_NIFM_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Warn, 2, format, args)
#define NN_DETAIL_NIFM_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Warn, 3, format, args)

#define NN_DETAIL_NIFM_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Error, 0, format, args)
#define NN_DETAIL_NIFM_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Error, 1, format, args)
#define NN_DETAIL_NIFM_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Error, 2, format, args)
#define NN_DETAIL_NIFM_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Error, 3, format, args)

#define NN_DETAIL_NIFM_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Fatal, 0, format, args)
#define NN_DETAIL_NIFM_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Fatal, 1, format, args)
#define NN_DETAIL_NIFM_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Fatal, 2, format, args)
#define NN_DETAIL_NIFM_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Fatal, 3, format, args)

#define NN_DETAIL_NIFM_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Trace, 0, text, length)
#define NN_DETAIL_NIFM_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Trace, 1, text, length)
#define NN_DETAIL_NIFM_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Trace, 2, text, length)
#define NN_DETAIL_NIFM_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Trace, 3, text, length)

#define NN_DETAIL_NIFM_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Info, 0, text, length)
#define NN_DETAIL_NIFM_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Info, 1, text, length)
#define NN_DETAIL_NIFM_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Info, 2, text, length)
#define NN_DETAIL_NIFM_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Info, 3, text, length)

#define NN_DETAIL_NIFM_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Warn, 0, text, length)
#define NN_DETAIL_NIFM_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Warn, 1, text, length)
#define NN_DETAIL_NIFM_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Warn, 2, text, length)
#define NN_DETAIL_NIFM_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Warn, 3, text, length)

#define NN_DETAIL_NIFM_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Error, 0, text, length)
#define NN_DETAIL_NIFM_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Error, 1, text, length)
#define NN_DETAIL_NIFM_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Error, 2, text, length)
#define NN_DETAIL_NIFM_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Error, 3, text, length)

#define NN_DETAIL_NIFM_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Fatal, 0, text, length)
#define NN_DETAIL_NIFM_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Fatal, 1, text, length)
#define NN_DETAIL_NIFM_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Fatal, 2, text, length)
#define NN_DETAIL_NIFM_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Fatal, 3, text, length)

#else

// ログ無効の場合 _V3 のみ表示する

#define NN_DETAIL_NIFM_TRACE(...)                   ((void)0)
#define NN_DETAIL_NIFM_TRACE_V1(...)                ((void)0)
#define NN_DETAIL_NIFM_TRACE_V2(...)                ((void)0)
#define NN_DETAIL_NIFM_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Trace, 3, ##__VA_ARGS__)
#define NN_DETAIL_NIFM_INFO(...)                    ((void)0)
#define NN_DETAIL_NIFM_INFO_V1(...)                 ((void)0)
#define NN_DETAIL_NIFM_INFO_V2(...)                 ((void)0)
#define NN_DETAIL_NIFM_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIFM_WARN(...)                    ((void)0)
#define NN_DETAIL_NIFM_WARN_V1(...)                 ((void)0)
#define NN_DETAIL_NIFM_WARN_V2(...)                 ((void)0)
#define NN_DETAIL_NIFM_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIFM_ERROR(...)                   ((void)0)
#define NN_DETAIL_NIFM_ERROR_V1(...)                ((void)0)
#define NN_DETAIL_NIFM_ERROR_V2(...)                ((void)0)
#define NN_DETAIL_NIFM_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIFM_FATAL(...)                   ((void)0)
#define NN_DETAIL_NIFM_FATAL_V1(...)                ((void)0)
#define NN_DETAIL_NIFM_FATAL_V2(...)                ((void)0)
#define NN_DETAIL_NIFM_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(nifm, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIFM_VTRACE(format, args)         ((void)0)
#define NN_DETAIL_NIFM_VTRACE_V1(format, args)      ((void)0)
#define NN_DETAIL_NIFM_VTRACE_V2(format, args)      ((void)0)
#define NN_DETAIL_NIFM_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Trace, 3, format, args)

#define NN_DETAIL_NIFM_VINFO(format, args)          ((void)0)
#define NN_DETAIL_NIFM_VINFO_V1(format, args)       ((void)0)
#define NN_DETAIL_NIFM_VINFO_V2(format, args)       ((void)0)
#define NN_DETAIL_NIFM_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Info, 3, format, args)

#define NN_DETAIL_NIFM_VWARN(format, args)          ((void)0)
#define NN_DETAIL_NIFM_VWARN_V1(format, args)       ((void)0)
#define NN_DETAIL_NIFM_VWARN_V2(format, args)       ((void)0)
#define NN_DETAIL_NIFM_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Warn, 3, format, args)

#define NN_DETAIL_NIFM_VERROR(format, args)         ((void)0)
#define NN_DETAIL_NIFM_VERROR_V1(format, args)      ((void)0)
#define NN_DETAIL_NIFM_VERROR_V2(format, args)      ((void)0)
#define NN_DETAIL_NIFM_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Error, 3, format, args)

#define NN_DETAIL_NIFM_VFATAL(format, args)         ((void)0)
#define NN_DETAIL_NIFM_VFATAL_V1(format, args)      ((void)0)
#define NN_DETAIL_NIFM_VFATAL_V2(format, args)      ((void)0)
#define NN_DETAIL_NIFM_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(nifm, Fatal, 3, format, args)

#define NN_DETAIL_NIFM_PUT_TRACE(text, length)      ((void)0)
#define NN_DETAIL_NIFM_PUT_TRACE_V1(text, length)   ((void)0)
#define NN_DETAIL_NIFM_PUT_TRACE_V2(text, length)   ((void)0)
#define NN_DETAIL_NIFM_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Trace, 3, text, length)

#define NN_DETAIL_NIFM_PUT_INFO(text, length)       ((void)0)
#define NN_DETAIL_NIFM_PUT_INFO_V1(text, length)    ((void)0)
#define NN_DETAIL_NIFM_PUT_INFO_V2(text, length)    ((void)0)
#define NN_DETAIL_NIFM_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Info, 3, text, length)

#define NN_DETAIL_NIFM_PUT_WARN(text, length)       ((void)0)
#define NN_DETAIL_NIFM_PUT_WARN_V1(text, length)    ((void)0)
#define NN_DETAIL_NIFM_PUT_WARN_V2(text, length)    ((void)0)
#define NN_DETAIL_NIFM_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Warn, 3, text, length)

#define NN_DETAIL_NIFM_PUT_ERROR(text, length)      ((void)0)
#define NN_DETAIL_NIFM_PUT_ERROR_V1(text, length)   ((void)0)
#define NN_DETAIL_NIFM_PUT_ERROR_V2(text, length)   ((void)0)
#define NN_DETAIL_NIFM_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Error, 3, text, length)

#define NN_DETAIL_NIFM_PUT_FATAL(text, length)      ((void)0)
#define NN_DETAIL_NIFM_PUT_FATAL_V1(text, length)   ((void)0)
#define NN_DETAIL_NIFM_PUT_FATAL_V2(text, length)   ((void)0)
#define NN_DETAIL_NIFM_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(nifm, Fatal, 3, text, length)

#endif
