﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/nifm_TypesWirelessSetting.h>


namespace nn
{
namespace nifm
{
namespace detail
{
class WirelessUserSetting
{
public:
#if defined(NN_BUILD_CONFIG_OS_WIN)
    static const size_t XmlNecessarySize = 4096;
#endif
    static void ConvertSsidHexToString( char* pOutStringBuffer, int stringBufferSize, const Ssid& ssid ) NN_NOEXCEPT;

private:
    WirelessSettingData m_Setting;

public:
    WirelessUserSetting() NN_NOEXCEPT {}
    virtual ~WirelessUserSetting() NN_NOEXCEPT {}
    NN_IMPLICIT WirelessUserSetting( const WirelessSettingData& setting ) NN_NOEXCEPT;

public:
    unsigned char* GetSsidHex( unsigned char* pOutBuf, int *pOutLength ) const NN_NOEXCEPT;
    Ssid* GetSsid( Ssid *pOutSsid ) const NN_NOEXCEPT;
    char* GetSsidHexString( char* pOutStr ) const NN_NOEXCEPT;
    bool IsNonBroadcastEnabled() const NN_NOEXCEPT;
    Authentication GetAuthentication() const NN_NOEXCEPT;
    Encryption GetEncryption() const NN_NOEXCEPT;
    char* GetKeyMaterial( char* pOutStr, int* pOutLength, int inLength ) const NN_NOEXCEPT;
    int GetKeyMaterialCount() const NN_NOEXCEPT;

    void SetSsidHex( const unsigned char* pStr, int length ) NN_NOEXCEPT;
    void SetNonBroadcastEnabled( bool isEnabled ) NN_NOEXCEPT;
    void SetAuthentication( Authentication value ) NN_NOEXCEPT;
    void SetEncryption( Encryption value ) NN_NOEXCEPT;
    void SetKeyMaterial( const char *pStr, int length ) NN_NOEXCEPT;

    bool IsSameSsidAuthEncrypt(const WirelessUserSetting& rh) const NN_NOEXCEPT;

#if defined(NN_BUILD_CONFIG_OS_WIN)
    Result ConvertToXml( wchar_t *pOutXml, size_t size ) const NN_NOEXCEPT;
#endif

public:
    void Export(WirelessSettingData* pOutWirelessSettingData) const NN_NOEXCEPT;
};


}
}
}
