﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/core/profile/nifm_UserNetworkProfile.h>

namespace nn
{
namespace nifm
{
namespace detail
{

class TemporaryNetworkProfile : public UserNetworkProfile
{
public:
    explicit TemporaryNetworkProfile( nn::util::Uuid& id, const char* pName, bool autoConnect, bool largeCapacity, const WirelessUserSetting& wirelessSetting, const IpSetting& ipSetting ) NN_NOEXCEPT
        : UserNetworkProfile( id, pName, autoConnect, largeCapacity, wirelessSetting, ipSetting )
    {
    }

private:
    virtual ProfileType GetType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return ProfileType::TemporaryProfile;
    }
};

}
}
}
