﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/core/profile/nifm_WirelessUserSetting.h>
#include <nn/nifm/detail/core/profile/nifm_IpSetting.h>
#include <nn/nifm/nifm_TypesNetworkProfile.h>

#include <nn/util/util_IntrusiveList.h>

namespace nn
{
namespace nifm
{
namespace detail
{

class NetworkProfileBase
{
private:
    static WirelessUserSetting s_WirelessSettingDefault;  // TODO: TORIAEZU
    static IpSetting s_IpSettingDefault;  // TODO: TORIAEZU

private:
    nn::util::Uuid m_Id;
    char m_Name[NetworkProfileBasicInfo::NameSize];
    bool m_IsAutoConnect;
    bool m_IsLargeCapacity;

public:
    enum class ProfileType : uint8_t
    {
        UserProfile,
        SsidListProfile,
        TemporaryProfile,

        DummyProfile,

        Any,
        AnyIncludingDummy,
    };


public:
    NetworkProfileBase() NN_NOEXCEPT {}
    NN_IMPLICIT NetworkProfileBase( const nn::util::Uuid& id ) NN_NOEXCEPT; // TODO: SSID リスト向けも統一する
    explicit NetworkProfileBase( const nn::util::Uuid& id, const char* pName, bool autoConnect, bool largeCapacity ) NN_NOEXCEPT;
    virtual ~NetworkProfileBase() NN_NOEXCEPT {}

    void GetName( char* pOutStr ) const NN_NOEXCEPT;
    void SetName( const char* pStr ) NN_NOEXCEPT;

    bool GetAutoConnect() const NN_NOEXCEPT;
    void SetAutoConnect(bool isAutoConnect) NN_NOEXCEPT;

    bool GetLargeCapacity() const NN_NOEXCEPT;
    void SetLargeCapacity(bool isLargeCapacity) NN_NOEXCEPT;

    virtual NetworkInterfaceType GetNetworkInterfaceType() const NN_NOEXCEPT = 0;

    virtual void SetNetworkInterfaceType(NetworkInterfaceType networkInterfaceType) NN_NOEXCEPT
    {
        NN_UNUSED(networkInterfaceType);
    }

    virtual const WirelessUserSetting& GetWirelessSetting() const NN_NOEXCEPT
    {
        return s_WirelessSettingDefault;
    }

    virtual WirelessUserSetting* GetWirelessSettingPointer() NN_NOEXCEPT
    {
        return &s_WirelessSettingDefault;
    }

    virtual const WirelessUserSetting* GetWirelessSettingPointer() const NN_NOEXCEPT
    {
        return &s_WirelessSettingDefault;
    }

    virtual ProfileType GetType() const NN_NOEXCEPT = 0;

    virtual const IpSetting& GetIpSetting() const NN_NOEXCEPT
    {
        return s_IpSettingDefault;
    }

    // TODO: TORIAEZU
    virtual IpSetting* GetIpSettingPointer() NN_NOEXCEPT
    {
        return &s_IpSettingDefault;
    }

    virtual const IpSetting* GetIpSettingPointer() const NN_NOEXCEPT
    {
        return &s_IpSettingDefault;
    }

    virtual const nn::util::Uuid& GetId() const NN_NOEXCEPT
    {
        return m_Id;
    }

    virtual void SetId(const nn::util::Uuid& id) NN_NOEXCEPT
    {
        m_Id = id;
    }

    void Export(NetworkProfileData* pOutNetworkProfile) const NN_NOEXCEPT;

    // For Test
    static void GetDefaultIpSetting(IpSettingData* pOutIpSettingData) NN_NOEXCEPT;
    static void SetDefaultIpSetting(const IpSettingData& ipSetting) NN_NOEXCEPT;
};

}
}
}
