﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/nifm_TypesIpSetting.h>

namespace nn
{
namespace nifm
{
namespace detail
{

class IpSetting
{
private:
    IpSettingData m_Setting;

    static const uint16_t DefaultMtu = 1400;

public:
    IpSetting() NN_NOEXCEPT;
    virtual ~IpSetting() NN_NOEXCEPT;
    NN_IMPLICIT IpSetting( const IpSettingData& setting ) NN_NOEXCEPT;

public:

    bool IsIpAddressSettingAuto() const NN_NOEXCEPT;
    IpV4Address* GetIpAddress(IpV4Address* pOutIpAddress) const NN_NOEXCEPT;
    Bit8* GetIpAddress(Bit8* pOutIpAddress) const NN_NOEXCEPT;
    char* GetIpAddressString(char* pOutIpAddressString) const NN_NOEXCEPT;
    IpV4Address* GetSubnetMask(IpV4Address* pOutSubnetMask) const NN_NOEXCEPT;
    Bit8* GetSubnetMask(Bit8* pOutSubnetMask) const NN_NOEXCEPT;
    char* GetSubnetMaskString(char* pOutSubnetMaskString) const NN_NOEXCEPT;
    IpV4Address* GetDefaultGateway(IpV4Address* pOutDefaultGateway) const NN_NOEXCEPT;
    Bit8* GetDefaultGateway(Bit8* pOutDefaultGateway) const NN_NOEXCEPT;
    char* GetDefaultGatewayString(char* pOutDefaultGatewayString) const NN_NOEXCEPT;
    bool IsDnsSettingAuto() const NN_NOEXCEPT;
    IpV4Address* GetPreferredDns(IpV4Address* pOutDns) const NN_NOEXCEPT;
    Bit8* GetPreferredDns(Bit8* pOutDns) const NN_NOEXCEPT;
    char* GetPreferredDnsString(char* pOutDnsString) const NN_NOEXCEPT;
    IpV4Address* GetAlternateDns(IpV4Address* pOutDns) const NN_NOEXCEPT;
    Bit8* GetAlternateDns(Bit8* pOutDns) const NN_NOEXCEPT;
    char* GetAlternateDnsString(char* pOutDnsString) const NN_NOEXCEPT;
    bool IsProxyEnabled() const NN_NOEXCEPT;
    uint16_t GetProxyPort() const NN_NOEXCEPT;
    char* GetProxyHostname(char* pOutHostname) const NN_NOEXCEPT;
    bool IsProxyAuthEnabled() const NN_NOEXCEPT;
    char* GetProxyUsername(char* pOutUserName) const NN_NOEXCEPT;
    char* GetProxyPassword(char* pOutPassword) const NN_NOEXCEPT;
    uint16_t GetMtu() const NN_NOEXCEPT;

    void SetIpAddressSettingAuto(bool isAuto) NN_NOEXCEPT;
    void SetIpAddress(const IpV4Address* pIpAddress) NN_NOEXCEPT;
    void SetIpAddress(const Bit8* pIpAddress) NN_NOEXCEPT;
    void SetSubnetMask(const IpV4Address* pSubnetMask)NN_NOEXCEPT;
    void SetSubnetMask(const Bit8* pSubnetMask)NN_NOEXCEPT;
    void SetDefaultGateway(const IpV4Address* pDefaultGateway) NN_NOEXCEPT;
    void SetDefaultGateway(const Bit8* pDefaultGateway) NN_NOEXCEPT;
    void SetDnsSettingAuto(bool isAuto) NN_NOEXCEPT;
    void SetPreferredDns(const IpV4Address* pDns) NN_NOEXCEPT;
    void SetPreferredDns(const Bit8* pDns) NN_NOEXCEPT;
    void SetAlternateDns(const IpV4Address* pDns) NN_NOEXCEPT;
    void SetAlternateDns(const Bit8* pDns) NN_NOEXCEPT;
    void SetProxyEnabled(bool isEnabled) NN_NOEXCEPT;
    void SetProxyPort(uint16_t port) NN_NOEXCEPT;
    void SetProxyHostname(const char *pHostname) NN_NOEXCEPT;
    void SetProxyAuthEnabled(const bool isEnabled) NN_NOEXCEPT;
    void SetProxyUsername(const char *pUserName) NN_NOEXCEPT;
    void SetProxyPassword(const char *pPassword) NN_NOEXCEPT;
    void SetMtu(uint16_t mtu) NN_NOEXCEPT;

    bool operator==(const IpSetting& rh) const NN_NOEXCEPT;
    bool operator!=(const IpSetting& rh) const NN_NOEXCEPT;
    NN_IMPLICIT operator IpSettingData() const NN_NOEXCEPT;
    IpSetting& operator=( const IpSetting& rh ) NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT;
    void ConvertIpV4AddressToString( char* pOutStr, const IpV4Address* pAddress ) const NN_NOEXCEPT;

    void Export(IpSettingData* pOutIpSetting) const NN_NOEXCEPT;
};


}
}
}
