﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class HttpResponse
{
public:
    static const int Size = 3 * 1024;

private:
    char m_Buffer[Size];
    int m_Length;

public:
    HttpResponse() NN_NOEXCEPT;
    ~HttpResponse() NN_NOEXCEPT;

    int Add(const char* pContent, int size) NN_NOEXCEPT;

    const char* GetPointer() const NN_NOEXCEPT;
    int GetLength() const NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT;
};

}
}
}
