﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/nifm_TypesProxySetting.h>
#include <nn/nifm/nifm_TypesNetworkInterface.h>

namespace nn
{
namespace nifm
{
namespace detail
{

class HttpPostData;
class HttpResponse;

class HttpClientBase
{
public:
    enum class HttpRequestMethod : uint8_t
    {
        Get,
        Post,
        Put,
        Delete,
    } m_HttpRequestMethod;

public:
    HttpClientBase() NN_NOEXCEPT;
    ~HttpClientBase() NN_NOEXCEPT;

    void SetNetworkInterfaceType(nn::nifm::NetworkInterfaceType networkInterfaceType) NN_NOEXCEPT;
    void SetProxySetting(const ProxySetting& proxySetting) NN_NOEXCEPT;
    void SetCurlCommonOpt() NN_NOEXCEPT;
    void SetRequestUrl(const char* pUrl) NN_NOEXCEPT;
    void SetRequesetMethod(HttpRequestMethod method) NN_NOEXCEPT;

    void SetPostDataBuffer(HttpPostData* pPostData) NN_NOEXCEPT;
    void SetResponseBuffer(HttpResponse* pResponse) NN_NOEXCEPT;

    void AddPostData(const char* pKey, const char* pValue) NN_NOEXCEPT;

    nn::Result Connect() NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT;
};


}
}
}
