﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/detail/core/connectionConfirmation/nifm_HttpClientBase.win32.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class ConnectionTestClient : public HttpClientBase
{
    NN_DISALLOW_COPY(ConnectionTestClient);
    NN_DISALLOW_MOVE(ConnectionTestClient);

public:
    static const char ConnTestUrl[];

public:
    ConnectionTestClient() NN_NOEXCEPT;
    ~ConnectionTestClient() NN_NOEXCEPT;

    nn::Result ConfirmInternetConnection(const char* pUrl) NN_NOEXCEPT;

    const char* GetRedirectUrlPointer() const NN_NOEXCEPT;
};

}
}
}
