﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nfc/server/core/nfc_Types.h>

#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
#define NN_NFC_SERVER_UTIL_REQUIRES(condition, ...) NN_SDK_REQUIRES(condition, ##__VA_ARGS__)
#define NN_NFC_SERVER_UTIL_REQUIRES_EQUAL(lhs, rhs) NN_SDK_REQUIRES_EQUAL(lhs, rhs)
#define NN_NFC_SERVER_UTIL_REQUIRES_NOT_NULL(pointer) NN_SDK_REQUIRES_NOT_NULL(pointer)
#else
#define NN_NFC_SERVER_UTIL_REQUIRES(condition, ...) NN_RESULT_THROW_UNLESS(condition, nn::nfc::ResultBadRequest())
#define NN_NFC_SERVER_UTIL_REQUIRES_EQUAL(lhs, rhs) NN_RESULT_THROW_UNLESS(lhs == rhs, nn::nfc::ResultBadRequest())
#define NN_NFC_SERVER_UTIL_REQUIRES_NOT_NULL(pointer) NN_RESULT_THROW_UNLESS(pointer != nullptr, nn::nfc::ResultBadRequest())
#endif

namespace nn { namespace nfc { namespace server { namespace util {

bool IsEqualDeviceHandle(const nn::nfc::DeviceHandle& lhs, const nn::nfc::DeviceHandle& rhs) NN_NOEXCEPT;
bool IsEqualTagId(const nn::nfc::TagId& lhs, const nn::nfc::TagId& rhs) NN_NOEXCEPT;

}}}}  // namespace nn::nfc::server::util
