﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Mutex.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/nfp/nfp_Result.h>
#include <nn/nfp/nfp_Types.h>
#include <nn/nfc/server/core/nfc_Types.h>
#include <nn/nfc/server/core/nfc_CoreService.h>

namespace nn { namespace nfc { namespace server {

class Tag
{
public:
    Tag(const nn::nfc::DeviceHandle deviceHandle, const nn::nfc::TagId& id, nn::nfc::NfcProtocol protocol, nn::nfc::TagType type, nn::os::SystemEventType* accessFinishEvent, nn::os::SystemEventType* accessResetEvent) NN_NOEXCEPT;
    virtual ~Tag() NN_NOEXCEPT;
    bool operator ==(const Tag& rhs) const NN_NOEXCEPT;
    bool operator !=(const Tag& rhs) const NN_NOEXCEPT;
    nn::nfc::TagId GetId() NN_NOEXCEPT;
    nn::nfc::NfcProtocol GetProtocol() NN_NOEXCEPT;
    nn::nfc::TagType GetType() NN_NOEXCEPT;
    nn::Result SendCommand(void* pOutBuffer, size_t* pOutSize, nn::nfc::server::core::Service* service, const void* pData, size_t dataSize, size_t bufferSize, nn::TimeSpan timeout) NN_NOEXCEPT;
    bool IsNtag() NN_NOEXCEPT;

private:
    Tag() NN_NOEXCEPT;

protected:
    nn::Result WaitInfo(nn::nfc::server::core::Info* pOutInfo, nn::nfc::server::core::Service* service, nn::nfc::DeviceHandle handle, int64_t timeoutMsec) NN_NOEXCEPT;
    void ClearEvent() NN_NOEXCEPT;

protected:
    nn::nfc::DeviceHandle m_Handle;
    nn::nfc::TagId m_Id;
    nn::nfc::NfcProtocol m_Protocol;
    nn::nfc::TagType m_Type;
    mutable nn::os::MutexType m_Mutex;
    nn::os::SystemEventType* m_pAccessFinishEvent;
    nn::os::SystemEventType* m_pAccessResetEvent;
};

}}}  // namespace nn::nfc::server
