﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nfc/server/core/nfc_CoreService.h>
#include <nn/nfc/nfc_Types.h>
#include <nn/nfc/server/core/nfc_Result.h>

namespace nn { namespace nfc { namespace server { namespace core {

class ScopedSession
{
public:
    ScopedSession(nn::nfc::server::core::Service* service, nn::nfc::DeviceHandle handle) NN_NOEXCEPT;
    nn::Result Keep() NN_NOEXCEPT;
    void Release() NN_NOEXCEPT;
    ~ScopedSession() NN_NOEXCEPT;

private:
    nn::nfc::DeviceHandle m_Handle;
    nn::nfc::server::core::Service* m_Service;
    bool m_IsKept;
};

}}}}  // namespace nn::nfc::server::core
