﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/os/os_Mutex.h>
#include <nn/nfc/nfc_Result.h>
#include <nn/nfc/nfc_PrivateResult.h>
#include <nn/nfc/nfc_NfpResult.internal.h>
#include <nn/nfc/server/core/nfc_Result.h>

namespace nn { namespace nfc { namespace server { namespace core {

class FileStream;

/**
 * @brief         セーブデータの操作クラスです。
 */
class SaveData
{
public:
    static const char* FilePathNfpBackup;
    static const char* FilePathNfcTerminalId;

    static const int FileCountMax = 2;
    static const char* FilePathList[FileCountMax];

    static const int64_t SystemSaveDataSize;
    static const int64_t SystemSaveDataCommitSize;
    static const int64_t SystemSaveDataJournalSize;

    static SaveData& GetInstance() NN_NOEXCEPT
    {
        static SaveData instance;
        return instance;
    }

    bool IsInitialized() NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    nn::Result Format() NN_NOEXCEPT;
    static nn::Result Create(const char* path, int64_t size) NN_NOEXCEPT;
    static nn::Result Delete(const char* path) NN_NOEXCEPT;
    nn::Result Open(int* pOutFileHandle, const char* path, int mode) NN_NOEXCEPT;
    nn::Result SetPosition(int fileHandle, int64_t position) NN_NOEXCEPT;
    nn::Result Read(size_t* pOutSize, void* pOutBuffer, int fileHandle, size_t bufferSize) NN_NOEXCEPT;
    nn::Result Read(void* pOutBuffer, int fileHandle, size_t readAndBufferSize) NN_NOEXCEPT;
    nn::Result Write(int fileHandle, const void* pData, size_t dataSize, bool flush) NN_NOEXCEPT;
    nn::Result GetSize(int64_t* pOutSize, int fileHandle) NN_NOEXCEPT;
    nn::Result Flush(int fileHandle) NN_NOEXCEPT;
    nn::Result Close(int fileHandle) NN_NOEXCEPT;
    static nn::Result Commit() NN_NOEXCEPT;

private:
    static const int FileStreamCountMax = 2;

    SaveData() NN_NOEXCEPT;
    ~SaveData() NN_NOEXCEPT;

    mutable nn::os::MutexType m_Mutex;
    std::unique_ptr<FileStream> m_FileStream[FileStreamCountMax];
    bool m_IsInitialized;
    nn::Result m_Result;
};

}}}}  // namespace nn::nfc::server::core
