﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_IntrusiveList.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/nfc/nfc_Types.h>

namespace nn { namespace nfc { namespace server { namespace core {

class DeviceEvent : public nn::util::IntrusiveListBaseNode<DeviceEvent>
{
public:
    DeviceEvent() NN_NOEXCEPT;
    ~DeviceEvent() NN_NOEXCEPT;

    void Initialize(const nn::nfc::DeviceHandle& handle) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    bool IsInitialized() NN_NOEXCEPT;
    bool IsEqual(const nn::nfc::DeviceHandle& handle) NN_NOEXCEPT;

    nn::os::SystemEventType& GetActivateEvent() NN_NOEXCEPT;
    nn::os::SystemEventType& GetDeactivateEvent() NN_NOEXCEPT;

private:
    bool m_IsInitialized;
    nn::nfc::DeviceHandle m_Handle;
    nn::os::SystemEventType m_ActivateEvent;
    nn::os::SystemEventType m_DeactivateEvent;
};

}}}}  // namespace nn::nfc::server::core
