﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Types.h>
#include <nn/applet/applet_Types.h>
#include <nn/nfc/server/core/nfc_Types.h>
#include <nn/xcd/xcd_NfcTypes.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/nfc/server/core/nfc_DeviceEvent.h>

namespace nn { namespace nfc { namespace server { namespace core {

    typedef nn::sf::InArray<nn::xcd::McuVersionDataForNfc> McuVersionDataInArray;

    enum : size_t
    {
        McuVersionDataCountMax = 4ul
    };

    struct McuVersionData
    {
        size_t                        count;
        nn::xcd::McuVersionDataForNfc version[McuVersionDataCountMax];
    };

    class Service
    {
    public:
        static Service* NfcProcessService;

    public:
        explicit Service(LibraryType libType) NN_NOEXCEPT;
        virtual ~Service() NN_NOEXCEPT;
        void SetLibraryType(LibraryType libType) NN_NOEXCEPT;
        LibraryType GetLibraryType() NN_NOEXCEPT;
        nn::applet::AppletResourceUserId GetAppletResourceUserId() NN_NOEXCEPT;
        nn::os::ProcessId GetPid() NN_NOEXCEPT;
        McuVersionData GetMcuVersionData() NN_NOEXCEPT;
        void Initialize(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const McuVersionDataInArray& versionData) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;
        nn::Result GetActivateEventHandle(nn::os::NativeHandle* handle, const nn::nfc::DeviceHandle& deviceHandle, nn::nfc::DeviceHandle* devices, int count) NN_NOEXCEPT;
        nn::Result GetDeactivateEventHandle(nn::os::NativeHandle* handle, const nn::nfc::DeviceHandle& deviceHandle, nn::nfc::DeviceHandle* devices, int count) NN_NOEXCEPT;
        nn::Result GetAvailabilityChangeEventHandle(nn::os::NativeHandle* handle) NN_NOEXCEPT;
        void SignalActivateEvent(const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        void SignalDeactivateEvent(const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;
        void SignalAvailabilityChangeEvent() NN_NOEXCEPT;
        void ClearDetectEvent(const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT;

    private:
        Service() NN_NOEXCEPT;
        nn::Result SetDeviceEvent(const nn::nfc::DeviceHandle& deviceHandle, nn::nfc::DeviceHandle* devices, int count) NN_NOEXCEPT;

    private:
        LibraryType m_LibType;
        nn::applet::AppletResourceUserId m_Aruid;
        nn::os::ProcessId m_Pid;
        McuVersionData m_McuVersionData;
        nn::util::IntrusiveList<DeviceEvent, nn::util::IntrusiveListBaseNodeTraits<DeviceEvent>> m_DeviceEventList;
        nn::os::SystemEventType m_AvailabilityChangeEvent;
    };

}}}}  // namespace nn::nfc::server::core
