﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/os/os_MultipleWait.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/os/os_Tick.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/nfc/nfc_Result.h>
#include <nn/nfc/nfc_PrivateResult.h>
#include <nn/nfc/nfc_NfpResult.internal.h>
#include <nn/nfc/server/core/nfc_CoreService.h>
#include <nn/nfc/server/core/nfc_ScopedSession.h>

namespace nn { namespace nfc { namespace server {
    class Device;
    class Tag;
}}}

namespace nn { namespace nfc { namespace pt { namespace server {

class Device
{
public:
    explicit Device(nn::nfc::server::Device* device) NN_NOEXCEPT;
    ~Device() NN_NOEXCEPT;
    nn::Result SendCommand(void* pOutBuffer, size_t* pOutSize, nn::nfc::server::core::Service* service, const void* pData, size_t dataSize, size_t bufferSize, nn::TimeSpan timeout) NN_NOEXCEPT;
    nn::Result KeepSession(nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result ReleaseSession() NN_NOEXCEPT;

private:
    Device() NN_NOEXCEPT;
    nn::Result CheckKeep() NN_NOEXCEPT;

private:
    nn::nfc::server::Device* m_Device;

    std::unique_ptr<nn::nfc::server::Tag> m_KeptTag;
    std::unique_ptr<nn::nfc::server::core::ScopedSession> m_Session;
};

}}}}  // namespace nn::nfc::pt::server
