﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/nfc/nfc_MifareTypes.h>
#include <nn/nfc/nfc_Types.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/xcd/xcd_NfcTypes.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace nfc { namespace detail { // NOLINT(whitespace/braces)

class IUser;

class IUserManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IUser, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IUser)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InitializeNfc, (::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(FinalizeNfc)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStateNfc, (::nn::sf::Out<::nn::Bit32> state))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsNfcEnabledNfc, (::nn::sf::Out<bool> isNfcEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::Bit32> state))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsNfcEnabled, (::nn::sf::Out<bool> isNfcEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListDevices, (const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>& devices, ::nn::sf::Out<::std::int32_t> count))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceState, (::nn::sf::Out<::nn::Bit32> state, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadId, (::nn::sf::Out<::nn::hid::NpadIdType> npadId, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailabilityChangeEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartDetection, (::nn::nfc::DeviceHandle deviceHandle, ::nn::Bit32 protocolFilter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StopDetection, (::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTagInfo, (::nn::sf::Out<::nn::nfc::TagInfo> tagInfo, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActivateEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeactivateEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadMifare, (const ::nn::sf::OutArray<::nn::nfc::MifareReadBlockData>& blockData, ::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareReadBlockParameter>& blockParameter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WriteMifare, (::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareWriteBlockParameter>& blockParameter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendCommandByPassThrough, (const ::nn::sf::OutBuffer& buffer, ::nn::sf::Out<::std::uint32_t> size, ::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InBuffer& data, ::nn::TimeSpan timeout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(KeepPassThroughSession, (::nn::nfc::DeviceHandle deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReleasePassThroughSession, (::nn::nfc::DeviceHandle deviceHandle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IUser)

        ::nn::Result InitializeNfc(::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InitializeNfc, (aruid, pid, mcuVersionData));
        }

        ::nn::Result FinalizeNfc() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(FinalizeNfc);
        }

        ::nn::Result GetStateNfc(::nn::sf::Out<::nn::Bit32> state) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStateNfc, (state));
        }

        ::nn::Result IsNfcEnabledNfc(::nn::sf::Out<bool> isNfcEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsNfcEnabledNfc, (isNfcEnabled));
        }

        ::nn::Result Initialize(::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Initialize, (aruid, pid, mcuVersionData));
        }

        ::nn::Result Finalize() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Finalize);
        }

        ::nn::Result GetState(::nn::sf::Out<::nn::Bit32> state) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetState, (state));
        }

        ::nn::Result IsNfcEnabled(::nn::sf::Out<bool> isNfcEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsNfcEnabled, (isNfcEnabled));
        }

        ::nn::Result ListDevices(const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>& devices, ::nn::sf::Out<::std::int32_t> count) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListDevices, (devices, count));
        }

        ::nn::Result GetDeviceState(::nn::sf::Out<::nn::Bit32> state, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeviceState, (state, deviceHandle));
        }

        ::nn::Result GetNpadId(::nn::sf::Out<::nn::hid::NpadIdType> npadId, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNpadId, (npadId, deviceHandle));
        }

        ::nn::Result GetAvailabilityChangeEventHandle(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAvailabilityChangeEventHandle, (handle));
        }

        ::nn::Result StartDetection(::nn::nfc::DeviceHandle deviceHandle, ::nn::Bit32 protocolFilter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartDetection, (deviceHandle, protocolFilter));
        }

        ::nn::Result StopDetection(::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StopDetection, (deviceHandle));
        }

        ::nn::Result GetTagInfo(::nn::sf::Out<::nn::nfc::TagInfo> tagInfo, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTagInfo, (tagInfo, deviceHandle));
        }

        ::nn::Result GetActivateEventHandle(::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActivateEventHandle, (handle, deviceHandle));
        }

        ::nn::Result GetDeactivateEventHandle(::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeactivateEventHandle, (handle, deviceHandle));
        }

        ::nn::Result ReadMifare(const ::nn::sf::OutArray<::nn::nfc::MifareReadBlockData>& blockData, ::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareReadBlockParameter>& blockParameter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadMifare, (blockData, deviceHandle, blockParameter));
        }

        ::nn::Result WriteMifare(::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareWriteBlockParameter>& blockParameter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WriteMifare, (deviceHandle, blockParameter));
        }

        ::nn::Result SendCommandByPassThrough(const ::nn::sf::OutBuffer& buffer, ::nn::sf::Out<::std::uint32_t> size, ::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InBuffer& data, ::nn::TimeSpan timeout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendCommandByPassThrough, (buffer, size, deviceHandle, data, timeout));
        }

        ::nn::Result KeepPassThroughSession(::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(KeepPassThroughSession, (deviceHandle));
        }

        ::nn::Result ReleasePassThroughSession(::nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReleasePassThroughSession, (deviceHandle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IUser
    {
    public:
        nn::Result InitializeNfc(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT;
        nn::Result FinalizeNfc() NN_NOEXCEPT;
        nn::Result GetStateNfc(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT;
        nn::Result IsNfcEnabledNfc(nn::sf::Out<bool> isNfcEnabled) NN_NOEXCEPT;
        nn::Result Initialize(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT;
        nn::Result Finalize() NN_NOEXCEPT;
        nn::Result GetState(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT;
        nn::Result IsNfcEnabled(nn::sf::Out<bool> isNfcEnabled) NN_NOEXCEPT;
        nn::Result ListDevices(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
        nn::Result GetDeviceState(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetNpadId(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetAvailabilityChangeEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result StartDetection(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 protocolFilter) NN_NOEXCEPT;
        nn::Result StopDetection(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetTagInfo(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetActivateEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result GetDeactivateEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result ReadMifare(const nn::sf::OutArray<nn::nfc::MifareReadBlockData>& blockData, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareReadBlockParameter>& blockParameter) NN_NOEXCEPT;
        nn::Result WriteMifare(nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareWriteBlockParameter>& blockParameter) NN_NOEXCEPT;
        nn::Result SendCommandByPassThrough(const nn::sf::OutBuffer& buffer, nn::sf::Out<std::uint32_t> size, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InBuffer& data, nn::TimeSpan timeout) NN_NOEXCEPT;
        nn::Result KeepPassThroughSession(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
        nn::Result ReleasePassThroughSession(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result InitializeNfc(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT;
    nn::Result FinalizeNfc() NN_NOEXCEPT;
    nn::Result GetStateNfc(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT;
    nn::Result IsNfcEnabledNfc(nn::sf::Out<bool> isNfcEnabled) NN_NOEXCEPT;
    nn::Result Initialize(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT;
    nn::Result Finalize() NN_NOEXCEPT;
    nn::Result GetState(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT;
    nn::Result IsNfcEnabled(nn::sf::Out<bool> isNfcEnabled) NN_NOEXCEPT;
    nn::Result ListDevices(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT;
    nn::Result GetDeviceState(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetNpadId(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetAvailabilityChangeEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result StartDetection(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 protocolFilter) NN_NOEXCEPT;
    nn::Result StopDetection(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetTagInfo(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetActivateEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result GetDeactivateEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result ReadMifare(const nn::sf::OutArray<nn::nfc::MifareReadBlockData>& blockData, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareReadBlockParameter>& blockParameter) NN_NOEXCEPT;
    nn::Result WriteMifare(nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareWriteBlockParameter>& blockParameter) NN_NOEXCEPT;
    nn::Result SendCommandByPassThrough(const nn::sf::OutBuffer& buffer, nn::sf::Out<std::uint32_t> size, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InBuffer& data, nn::TimeSpan timeout) NN_NOEXCEPT;
    nn::Result KeepPassThroughSession(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result ReleasePassThroughSession(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nfc::detail::IUser))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeNfc, (::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InitializeNfc, (aruid, pid, mcuVersionData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FinalizeNfc)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(FinalizeNfc);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateNfc, (::nn::sf::Out<::nn::Bit32> state))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStateNfc, (state));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsNfcEnabledNfc, (::nn::sf::Out<bool> isNfcEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsNfcEnabledNfc, (isNfcEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Initialize, (aruid, pid, mcuVersionData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Finalize);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::Bit32> state))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetState, (state));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsNfcEnabled, (::nn::sf::Out<bool> isNfcEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsNfcEnabled, (isNfcEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDevices, (const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>& devices, ::nn::sf::Out<::std::int32_t> count))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListDevices, (devices, count));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceState, (::nn::sf::Out<::nn::Bit32> state, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeviceState, (state, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadId, (::nn::sf::Out<::nn::hid::NpadIdType> npadId, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNpadId, (npadId, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailabilityChangeEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAvailabilityChangeEventHandle, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartDetection, (::nn::nfc::DeviceHandle deviceHandle, ::nn::Bit32 protocolFilter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartDetection, (deviceHandle, protocolFilter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopDetection, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StopDetection, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTagInfo, (::nn::sf::Out<::nn::nfc::TagInfo> tagInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTagInfo, (tagInfo, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActivateEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActivateEventHandle, (handle, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeactivateEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeactivateEventHandle, (handle, deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadMifare, (const ::nn::sf::OutArray<::nn::nfc::MifareReadBlockData>& blockData, ::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareReadBlockParameter>& blockParameter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadMifare, (blockData, deviceHandle, blockParameter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteMifare, (::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareWriteBlockParameter>& blockParameter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WriteMifare, (deviceHandle, blockParameter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendCommandByPassThrough, (const ::nn::sf::OutBuffer& buffer, ::nn::sf::Out<::std::uint32_t> size, ::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InBuffer& data, ::nn::TimeSpan timeout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendCommandByPassThrough, (buffer, size, deviceHandle, data, timeout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(KeepPassThroughSession, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(KeepPassThroughSession, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReleasePassThroughSession, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReleasePassThroughSession, (deviceHandle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nfc::detail::IUser>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nfc::detail::IUser))

    // nn::Result InitializeNfc(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeNfc)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(mcuVersionData, 0, (const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (mcuVersionData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (aruid, pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mcuVersionData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeNfc)

    // nn::Result FinalizeNfc() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinalizeNfc)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinalizeNfc)

    // nn::Result GetStateNfc(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStateNfc)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(state, (::nn::Bit32), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (state))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(state)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStateNfc)

    // nn::Result IsNfcEnabledNfc(nn::sf::Out<bool> isNfcEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsNfcEnabledNfc)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isNfcEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isNfcEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isNfcEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsNfcEnabledNfc)

    // nn::Result Initialize(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Initialize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(400)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(mcuVersionData, 0, (const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (mcuVersionData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (aruid, pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mcuVersionData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Initialize)

    // nn::Result Finalize() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Finalize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(401)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Finalize)

    // nn::Result GetState(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(402)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(state, (::nn::Bit32), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (state))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(state)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetState)

    // nn::Result IsNfcEnabled(nn::sf::Out<bool> isNfcEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsNfcEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(403)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isNfcEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isNfcEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isNfcEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsNfcEnabled)

    // nn::Result ListDevices(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListDevices)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(404)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(devices, 0, (const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (devices))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(count, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (count))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(devices), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(count)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListDevices)

    // nn::Result GetDeviceState(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeviceState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(405)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(state, (::nn::Bit32), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (state))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(state), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeviceState)

    // nn::Result GetNpadId(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNpadId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(406)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(npadId, (::nn::hid::NpadIdType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (npadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(npadId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNpadId)

    // nn::Result GetAvailabilityChangeEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAvailabilityChangeEventHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(407)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAvailabilityChangeEventHandle)

    // nn::Result StartDetection(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 protocolFilter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartDetection)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(408)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(protocolFilter, (::nn::Bit32), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (deviceHandle, protocolFilter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(protocolFilter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartDetection)

    // nn::Result StopDetection(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopDetection)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(409)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopDetection)

    // nn::Result GetTagInfo(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTagInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(410)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(tagInfo, 0, (::nn::sf::Out<::nn::nfc::TagInfo>), 88, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (tagInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(tagInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTagInfo)

    // nn::Result GetActivateEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActivateEventHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(411)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActivateEventHandle)

    // nn::Result GetDeactivateEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeactivateEventHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(412)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeactivateEventHandle)

    // nn::Result ReadMifare(const nn::sf::OutArray<nn::nfc::MifareReadBlockData>& blockData, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareReadBlockParameter>& blockParameter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(blockData, 0, (const ::nn::sf::OutArray<::nn::nfc::MifareReadBlockData>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(blockParameter, 1, (const ::nn::sf::InArray<::nn::nfc::MifareReadBlockParameter>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (blockData, blockParameter))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(blockData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(blockParameter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadMifare)

    // nn::Result WriteMifare(nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareWriteBlockParameter>& blockParameter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WriteMifare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(blockParameter, 0, (const ::nn::sf::InArray<::nn::nfc::MifareWriteBlockParameter>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (blockParameter))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(blockParameter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WriteMifare)

    // nn::Result SendCommandByPassThrough(const nn::sf::OutBuffer& buffer, nn::sf::Out<std::uint32_t> size, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InBuffer& data, nn::TimeSpan timeout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendCommandByPassThrough)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1300)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(data, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (buffer, data))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(timeout, (::nn::TimeSpan), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (deviceHandle, timeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(size, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(data), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(timeout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendCommandByPassThrough)

    // nn::Result KeepPassThroughSession(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(KeepPassThroughSession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1301)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(KeepPassThroughSession)

    // nn::Result ReleasePassThroughSession(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReleasePassThroughSession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1302)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::nn::nfc::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReleasePassThroughSession)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::xcd::McuVersionDataForNfc), 32, 2)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfc::DeviceHandle), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::NpadIdType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfc::TagInfo), 88, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfc::MifareReadBlockData), 24, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfc::MifareReadBlockParameter), 24, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nfc::MifareWriteBlockParameter), 40, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::TimeSpan), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nfc::detail::IUser, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nfc::detail::IUser))

    // nn::Result InitializeNfc(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeNfc, (::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeNfc)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mcuVersionData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeNfc)
    }

    // nn::Result FinalizeNfc() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FinalizeNfc)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinalizeNfc)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinalizeNfc)
    }

    // nn::Result GetStateNfc(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStateNfc, (::nn::sf::Out<::nn::Bit32> state))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStateNfc)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(state)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStateNfc)
    }

    // nn::Result IsNfcEnabledNfc(nn::sf::Out<bool> isNfcEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsNfcEnabledNfc, (::nn::sf::Out<bool> isNfcEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsNfcEnabledNfc)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isNfcEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsNfcEnabledNfc)
    }

    // nn::Result Initialize(nn::applet::AppletResourceUserId aruid, nn::Bit64 pid, const nn::sf::InArray<nn::xcd::McuVersionDataForNfc>& mcuVersionData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Initialize, (::nn::applet::AppletResourceUserId aruid, ::nn::Bit64 pid, const ::nn::sf::InArray<::nn::xcd::McuVersionDataForNfc>& mcuVersionData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Initialize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mcuVersionData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Initialize)
    }

    // nn::Result Finalize() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Finalize)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Finalize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Finalize)
    }

    // nn::Result GetState(nn::sf::Out<nn::Bit32> state) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::nn::Bit32> state))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(state)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetState)
    }

    // nn::Result IsNfcEnabled(nn::sf::Out<bool> isNfcEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsNfcEnabled, (::nn::sf::Out<bool> isNfcEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsNfcEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isNfcEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsNfcEnabled)
    }

    // nn::Result ListDevices(const nn::sf::OutArray<nn::nfc::DeviceHandle>& devices, nn::sf::Out<std::int32_t> count) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDevices, (const ::nn::sf::OutArray<::nn::nfc::DeviceHandle>& devices, ::nn::sf::Out<::std::int32_t> count))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListDevices)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(devices)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(count)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListDevices)
    }

    // nn::Result GetDeviceState(nn::sf::Out<nn::Bit32> state, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceState, (::nn::sf::Out<::nn::Bit32> state, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeviceState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(state)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeviceState)
    }

    // nn::Result GetNpadId(nn::sf::Out<nn::hid::NpadIdType> npadId, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadId, (::nn::sf::Out<::nn::hid::NpadIdType> npadId, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNpadId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(npadId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNpadId)
    }

    // nn::Result GetAvailabilityChangeEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailabilityChangeEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAvailabilityChangeEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAvailabilityChangeEventHandle)
    }

    // nn::Result StartDetection(nn::nfc::DeviceHandle deviceHandle, nn::Bit32 protocolFilter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartDetection, (::nn::nfc::DeviceHandle deviceHandle, ::nn::Bit32 protocolFilter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartDetection)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(protocolFilter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartDetection)
    }

    // nn::Result StopDetection(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopDetection, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopDetection)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopDetection)
    }

    // nn::Result GetTagInfo(nn::sf::Out<nn::nfc::TagInfo> tagInfo, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTagInfo, (::nn::sf::Out<::nn::nfc::TagInfo> tagInfo, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTagInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(tagInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTagInfo)
    }

    // nn::Result GetActivateEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActivateEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActivateEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActivateEventHandle)
    }

    // nn::Result GetDeactivateEventHandle(nn::sf::Out<nn::sf::NativeHandle> handle, nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeactivateEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeactivateEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeactivateEventHandle)
    }

    // nn::Result ReadMifare(const nn::sf::OutArray<nn::nfc::MifareReadBlockData>& blockData, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareReadBlockParameter>& blockParameter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadMifare, (const ::nn::sf::OutArray<::nn::nfc::MifareReadBlockData>& blockData, ::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareReadBlockParameter>& blockParameter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(blockData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(blockParameter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadMifare)
    }

    // nn::Result WriteMifare(nn::nfc::DeviceHandle deviceHandle, const nn::sf::InArray<nn::nfc::MifareWriteBlockParameter>& blockParameter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteMifare, (::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InArray<::nn::nfc::MifareWriteBlockParameter>& blockParameter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WriteMifare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(blockParameter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WriteMifare)
    }

    // nn::Result SendCommandByPassThrough(const nn::sf::OutBuffer& buffer, nn::sf::Out<std::uint32_t> size, nn::nfc::DeviceHandle deviceHandle, const nn::sf::InBuffer& data, nn::TimeSpan timeout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendCommandByPassThrough, (const ::nn::sf::OutBuffer& buffer, ::nn::sf::Out<::std::uint32_t> size, ::nn::nfc::DeviceHandle deviceHandle, const ::nn::sf::InBuffer& data, ::nn::TimeSpan timeout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendCommandByPassThrough)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(data)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(timeout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendCommandByPassThrough)
    }

    // nn::Result KeepPassThroughSession(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(KeepPassThroughSession, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(KeepPassThroughSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(KeepPassThroughSession)
    }

    // nn::Result ReleasePassThroughSession(nn::nfc::DeviceHandle deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReleasePassThroughSession, (::nn::nfc::DeviceHandle deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReleasePassThroughSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReleasePassThroughSession)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nfc::detail::IUser>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nfc::detail::IUser))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeNfc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(mcuVersionData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeNfc)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(mcuVersionData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinalizeNfc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinalizeNfc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStateNfc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStateNfc)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(state)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsNfcEnabledNfc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsNfcEnabledNfc)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isNfcEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(mcuVersionData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Initialize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(mcuVersionData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(state)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsNfcEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsNfcEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isNfcEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListDevices)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(devices)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListDevices)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(devices),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(count)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeviceState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeviceState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(state),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNpadId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(npadId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAvailabilityChangeEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAvailabilityChangeEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartDetection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartDetection)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(protocolFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopDetection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopDetection)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTagInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(tagInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTagInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(tagInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActivateEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActivateEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeactivateEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeactivateEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(blockData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(blockParameter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(blockData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(blockParameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WriteMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(blockParameter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WriteMifare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(blockParameter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendCommandByPassThrough)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(data)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendCommandByPassThrough)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(size),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(data),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(timeout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(KeepPassThroughSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(KeepPassThroughSession)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReleasePassThroughSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReleasePassThroughSession)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeNfc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinalizeNfc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStateNfc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsNfcEnabledNfc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Initialize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Finalize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsNfcEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListDevices)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeviceState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAvailabilityChangeEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartDetection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopDetection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTagInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActivateEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeactivateEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WriteMifare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendCommandByPassThrough)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(KeepPassThroughSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReleasePassThroughSession)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nfc::detail::IUser))

namespace nn { namespace nfc { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IUserManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IUserManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateUserInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nfc::detail::IUser>> pOutUserInterface))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IUserManager)

        ::nn::Result CreateUserInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::nfc::detail::IUser>> pOutUserInterface) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateUserInterface, (pOutUserInterface));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IUserManager
    {
    public:
        nn::Result CreateUserInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nfc::detail::IUser>> pOutUserInterface) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateUserInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nfc::detail::IUser>> pOutUserInterface) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nfc::detail::IUserManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateUserInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nfc::detail::IUser>> pOutUserInterface))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateUserInterface, (pOutUserInterface));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nfc::detail::IUserManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nfc::detail::IUserManager))

    // nn::Result CreateUserInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nfc::detail::IUser>> pOutUserInterface) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateUserInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutUserInterface, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutUserInterface))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutUserInterface)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateUserInterface)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nfc::detail::IUserManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nfc::detail::IUserManager))

    // nn::Result CreateUserInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nfc::detail::IUser>> pOutUserInterface) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateUserInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nfc::detail::IUser>> pOutUserInterface))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateUserInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutUserInterface)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateUserInterface)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nfc::detail::IUserManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nfc::detail::IUserManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateUserInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nfc::detail::IUser>), pOutUserInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateUserInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutUserInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutUserInterface, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateUserInterface)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nfc::detail::IUserManager))
