﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nfc/client/nfc_UserInterface.h>
#include <nn/nfc/client/nfc_SystemInterface.h>

#define NN_NFC_CLIENT_CHECK_COMMON_INTERFACE() \
    (nn::nfc::client::IsCreatedSystemInterface() ? nn::nfc::client::GetSystemInterface() != nullptr : nn::nfc::client::GetUserInterfaceForCommon() != nullptr)

#define NN_NFC_CLIENT_CHECK_COMMON_INTERFACE_WITHOUT_SYSTEM() \
    (nn::nfc::client::GetUserInterface() != nullptr)

#define NN_NFC_CLIENT_CHECK_COMMON_INTERFACE_WITHOUT_USER() \
    (nn::nfc::client::GetSystemInterface() != nullptr)



#define NN_NFC_CLIENT_GET_COMMON_INTERFACE(func, args) \
    (nn::nfc::client::IsCreatedSystemInterface() ? nn::nfc::client::GetSystemInterface()->func args : nn::nfc::client::GetUserInterfaceForCommon()->func args)

#define NN_NFC_CLIENT_GET_COMMON_INTERFACE_WITHOUT_SYSTEM(func, args) \
    (nn::nfc::client::GetUserInterface()->func args)

#define NN_NFC_CLIENT_GET_COMMON_INTERFACE_WITHOUT_USER(func, args) \
    (nn::nfc::client::GetSystemInterface()->func args)
