﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/** @file
    @brief      am に提供する NFC ライブラリの API の宣言
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/applet/applet_Types.h>

namespace nn {
namespace nfc {
namespace am {

/**
 * @name    am に提供する NFC ライブラリの API
 * @{
 */

/**
 * @brief   am 向け NFC ライブラリを初期化します。
 *
 * @pre
 *  - ライブラリが未初期化の状態である必要があります。
 *
 * @details
 *  この関数は、am 向け NFC ライブラリの各機能を使用する前に呼び出す必要があります。
 */
void Initialize() NN_NOEXCEPT;

/**
 * @brief   am 向け NFC ライブラリを終了します。
 *
 * @pre
 *  - ライブラリが @ref Initialize() にて初期化済みの状態である必要があります。
 *
 * @details
 *  この関数は am 向け NFC ライブラリの使用を終える際に呼び出してください。
 *
 */
void Finalize() NN_NOEXCEPT;


/**
 * @brief   NFC プロセスに Foreground のアプレットを通知します。
 *
 * @pre
 *  - ライブラリが @ref Initialize() にて初期化済みの状態である必要があります。
 *
 * @details
 * NFC プロセスに Foreground のアプレットのアプレットリソースユーザ ID を通知します。
 *
 */
void NotifyForegroundApplet(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;


/**
 * @}
 */

}  // am
}  // nfc
}  // nn
