﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/news_TypesAdmin.h>

namespace nn { namespace news {

/*!
    @name デバッグ
    @{
*/

/*!
    @brief      ニュースデータベースのダンプを取得します。

    @param[out] outSize 読み込んだサイズ。
    @param[in]  buffer  読み込みバッファ。
    @param[in]  size    読み込みバッファのサイズ。

    @return     処理結果。

    @pre
        - outSize != nullptr
        - buffer != nullptr
        - size > 0
*/
nn::Result GetNewsDatabaseDump(size_t* outSize, void* buffer, size_t size) NN_NOEXCEPT;

/*!
    @}
*/

}}
