﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/ipc/news_IServiceCreator.sfdl.h>
#include <nn/news/detail/ipc/news_ServiceConfig.h>

namespace nn { namespace news { namespace detail { namespace service {

/*!
    @brief      サービス生成器です。
*/
class ServiceCreatorForGeneric
{
public:
    /*!
        @brief      コンストラクタです。
    */
    ServiceCreatorForGeneric() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~ServiceCreatorForGeneric() NN_NOEXCEPT;

public:
    // IServiceCreator
    nn::Result CreateNewsService(nn::sf::Out<nn::sf::SharedPointer<nn::news::detail::ipc::INewsService>> outService) NN_NOEXCEPT;
    nn::Result CreateNewlyArrivedEventHolder(nn::sf::Out<nn::sf::SharedPointer<nn::news::detail::ipc::INewlyArrivedEventHolder>> outHolder) NN_NOEXCEPT;
    nn::Result CreateOverwriteEventHolder(nn::sf::Out<nn::sf::SharedPointer<nn::news::detail::ipc::IOverwriteEventHolder>> outHolder) NN_NOEXCEPT;
    nn::Result CreateNewsDataService(nn::sf::Out<nn::sf::SharedPointer<nn::news::detail::ipc::INewsDataService>> outService) NN_NOEXCEPT;
    nn::Result CreateNewsDatabaseService(nn::sf::Out<nn::sf::SharedPointer<nn::news::detail::ipc::INewsDatabaseService>> outService) NN_NOEXCEPT;
};

}}}}
