﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/ipc/news_INewsDatabaseService.sfdl.h>

namespace nn { namespace news { namespace detail { namespace service {

/*!
    @brief      データベースサービスです。
*/
class NewsDatabaseServiceForGeneric
{
public:
    /*!
        @brief      コンストラクタです。
    */
    NewsDatabaseServiceForGeneric() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~NewsDatabaseServiceForGeneric() NN_NOEXCEPT;

public:
    // INewsDatabaseService
    nn::Result GetList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::news::NewsRecord>& outRecords, const nn::sf::InArray<char>& wherePhrase, const nn::sf::InArray<char>& orderByPhrase, std::int32_t offset) NN_NOEXCEPT;
    nn::Result GetListV1(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::news::NewsRecordV1>& outRecords, const nn::sf::InArray<char>& wherePhrase, const nn::sf::InArray<char>& orderByPhrase, std::int32_t offset) NN_NOEXCEPT;
    nn::Result Count(nn::sf::Out<std::int32_t> outCount, const nn::sf::InArray<char>& wherePhrase) NN_NOEXCEPT;
    nn::Result CountWithKey(nn::sf::Out<std::int32_t> outCount, bool distinct, const nn::sf::InArray<char>& key, const nn::sf::InArray<char>& wherePhrase) NN_NOEXCEPT;
    nn::Result UpdateIntegerValue(const nn::sf::InArray<char>& key, std::int32_t value, const nn::sf::InArray<char>& wherePhrase) NN_NOEXCEPT;
    nn::Result UpdateIntegerValueWithAddition(const nn::sf::InArray<char>& key, std::int32_t value, const nn::sf::InArray<char>& wherePhrase) NN_NOEXCEPT;
    nn::Result UpdateStringValue(const nn::sf::InArray<char>& key, const nn::sf::InArray<char>& value, const nn::sf::InArray<char>& wherePhrase) NN_NOEXCEPT;
};

}}}}
