﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      ストレージの管理モジュールです。
*/
class StorageManager
{
private:
    NN_DISALLOW_COPY(StorageManager);
    NN_DISALLOW_MOVE(StorageManager);

private:
    /*!
        @brief      コンストラクタです。
    */
    StorageManager() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static StorageManager& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(StorageManager, instance);
        return instance;
    }

public:
    /*!
        @brief      ストレージの復帰処理を行います。

        @return     処理結果。

        @details
                    本関数は、本体起動直後に 1 度だけ呼び出すことを推奨します。
    */
    static nn::Result Recover() NN_NOEXCEPT;

public:
    /*!
        @brief      ストレージをロックします。
    */
    void Lock() NN_NOEXCEPT;

    /*!
        @brief      ストレージのロックを解除します。

        @pre
            - StorageManager::Lock でロックを取得済みである。
    */
    void Unlock() NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
};

}}}}}
