﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      パス生成モジュールです。
*/
class Path
{
public:
    /*!
        @brief      ニュースデータパスの最大長です。
    */
    static const size_t NewsDataPathLengthMax = 63;

public:
    /*!
        @brief      ニュースデータパスを生成します。

        @param[in]  path    バッファ。
        @param[in]  size    バッファサイズ。
        @param[in]  name    ニュースデータ名。

        @return     生成できたかどうか。

        @pre
            - path != nullptr
            - name != nullptr
    */
    static bool MakeNewsDataPath(char* path, size_t size, const char* name) NN_NOEXCEPT;

    /*!
        @brief      ニュースデータパスを生成します。

        @param[in]  path    バッファ。
        @param[in]  size    バッファサイズ。
        @param[in]  record  ニュースレコード。

        @return     生成できたかどうか。

        @pre
            - path != nullptr
    */
    static bool MakeNewsDataPath(char* path, size_t size, const NewsRecord& record) NN_NOEXCEPT;

    /*!
        @brief      ニュースデータパスを生成します。

        @param[in]  path    バッファ。
        @param[in]  size    バッファサイズ。
        @param[in]  record  ニュースレコード。

        @return     生成できたかどうか。

        @pre
            - path != nullptr
    */
    static bool MakeNewsDataPath(char* path, size_t size, const NewsRecordV1& record) NN_NOEXCEPT;
};

}}}}}
