﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      上書きイベントのリスナーです。
*/
class OverwriteEventListener
{
private:
    NN_DISALLOW_COPY(OverwriteEventListener);
    NN_DISALLOW_MOVE(OverwriteEventListener);

public:
    /*!
        @brief      登録できるイベントの最大数です。
    */
    static const int EventCountMax = 8;

private:
    /*!
        @brief      コンストラクタです。
    */
    OverwriteEventListener() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~OverwriteEventListener() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static OverwriteEventListener& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(OverwriteEventListener, instance);
        return instance;
    }

public:
    /*!
        @brief      イベントを登録します。

        @param[in]  eventHandle イベントのハンドル。

        @details
                    システムイベントの WritableHandle を指定してください。
    */
    void RegisterEvent(nn::os::NativeHandle eventHandle) NN_NOEXCEPT;

    /*!
        @brief      イベントを登録解除します。

        @param[in]  eventHandle イベントのハンドル。
    */
    void UnregisterEvent(nn::os::NativeHandle eventHandle) NN_NOEXCEPT;

    /*!
        @brief      シグナルします。
    */
    void SignalAll() NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
    //
    nn::os::SystemEventType m_Events[EventCountMax];
    bool m_IsRegistered[EventCountMax];
};

}}}}}
