﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      ニュースの購読モジュールです。
*/
class NewsSubscriber
{
public:
    /*!
        @brief      自動購読管理リストにアプリケーションを登録します。

        @param[in]  appId   アプリケーション ID。

        @pre
            - appId != nn::ApplicationId::GetInvalidId()

        @details
                    自動購読管理リストにアプリケーションが登録された場合、アプリケーション ID を引数に購読可能なトピックリストを非同期で取得します。@n
                    ローカルのトピックリストに存在しないトピックが発見された場合、システムは自動的にそれを購読します。

                    ユーザーによって購読解除されたトピックを再度自動購読することはありません。

                    自動購読管理リストは電源断によって消失します。
    */
    static void Register(nn::ApplicationId appId) NN_NOEXCEPT;

    /*!
        @brief      処理を行います。

        @param[in]  pCancelEvent    キャンセルイベント。

        @return     処理結果。

        @pre
            - pCancelEvent != nullptr

        @details
                    自動購読管理リストにアプリケーションが登録されていた場合、購読処理を行います。@n
                    購読に成功したアプリケーションは、自動購読管理リストから削除されます。
    */
    static nn::Result Process(nn::os::Event* pCancelEvent) NN_NOEXCEPT;

    /*!
        @brief      実行可能になった時に Signal されるイベントを取得します。

        @return     イベント。
    */
    static nn::os::TimerEvent& GetEvent() NN_NOEXCEPT;

    /*!
        @brief      トピックリスト URL に指定する居住国リストが更新されたことを通知します。
    */
    static void NotifyAccountCountryListUpdated() NN_NOEXCEPT;

    /*!
        @brief      ネットワークの接続を通知します。
    */
    static void NotifyNetworkConnected() NN_NOEXCEPT;
};

}}}}}
