﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      ニュースのインポートモジュールです。
*/
class NewsImporter
{
public:
    /*!
        @brief      ニュースをインポートします。（ローカル）

        @param[in]  data        ニュースデータ。
        @param[in]  dataSize    ニュースデータのサイズ。

        @return     処理結果。

        @pre
            - data != nullptr
            - dataSize > 0
    */
    static nn::Result ImportFromLocal(const void* data, size_t dataSize) NN_NOEXCEPT;

    /*!
        @brief      ニュースをインポートします。（ネットワーク）

        @param[in]  path                受信済みファイルのパス。
        @param[in]  isIndividual        個別通知かどうか。
        @param[in]  userId              ユーザー ID。
        @param[in]  language            言語。
        @param[in]  dataId              データ ID。
        @param[in]  isOverwrite         上書きフラグ。
        @param[in]  isTestDistribution  テスト配信フラグ。
        @param[in]  work                ワークバッファ。
        @param[in]  workSize            ワークバッファのサイズ。

        @return     処理結果。

        @pre
            - path != nullptr
            - work != nullptr
            - workSize > 0
    */
    static nn::Result ImportFromNetwork(const char* path,
        bool isIndividual, uint64_t userId, int8_t language, uint64_t dataId, bool isOverwrite, bool isTestDistribution,
        void* work, size_t workSize) NN_NOEXCEPT;
};

}}}}}
