﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      インクリメンタル ID 発行モジュールです。

    @details
                インクリメンタル ID は発行する度に異なる ID になります。@n
                発行状況はストレージに保存されるため、システムを再起動しても同じ ID が発行されることはありません。
*/
class IncrementalId
{
private:
    NN_DISALLOW_COPY(IncrementalId);
    NN_DISALLOW_MOVE(IncrementalId);

private:
    /*!
        @brief      コンストラクタです。
    */
    IncrementalId() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static IncrementalId& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(IncrementalId, instance);
        return instance;
    }

public:
    /*!
        @brief      インクリメンタル ID を発行します。

        @param[out] outId   インクリメンタル ID。

        @return     処理結果。

        @pre
            - outId != nullptr
    */
    nn::Result Issue(uint64_t* outId) NN_NOEXCEPT;

private:
    /*!
        @brief      1 回のファイルアクセスで確保する ID の数です。
    */
    static const int ReserveCount = 32;

private:
    //
    nn::os::Mutex m_Mutex;
    //
    uint64_t m_Base;
    //
    int m_Index;

private:
    //
    nn::Result ReserveRange() NN_NOEXCEPT;
};

}}}}}
