﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_Common.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

/*!
    @brief      アカウントの居住国確認モジュールです。
*/
class AccountCountryChecker
{
public:
    /*!
        @brief      配信リスト取得時に付与するクエリー文字列です。
    */
    struct QueryString
    {
        char value[96];
    };

private:
    /*!
        @brief      コンストラクタです。
    */
    AccountCountryChecker() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static AccountCountryChecker& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(AccountCountryChecker, instance);
        return instance;
    }

public:
    /*!
        @brief      初期化します。

        @return     処理結果。
    */
    nn::Result Initialize() NN_NOEXCEPT;

    /*!
        @brief      クエリー文字列を更新します。

        @return     クエリー文字列に変化があったかどうか。
    */
    bool UpdateQueryString() NN_NOEXCEPT;

    /*!
        @brief      クエリー文字列を取得します。

        @param[out] out クエリー文字列。

        @pre
            - out != nullptr
    */
    void GetQueryString(QueryString* out) NN_NOEXCEPT;

    /*!
        @brief      居住国リストをクエリー文字列に変換します。

        @param[out] out         クエリー文字列。
        @param[in]  countries   居住国リスト。
        @param[in]  count       居住国リストの要素数。

        @return     処理結果。

        @pre
            - out != nullptr
            - count <= nn::account::UserCountMax
    */
    static void ConvertCountryListToCountryQueryString(QueryString* out, const Account::Country* countries, int count) NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
    //
    QueryString m_CurrentQueryString;
};

}}}}}
